/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.quarkus.test.junit.QuarkusMainTestExtension;
import io.quarkus.test.junit.main.Launch;
import io.quarkus.test.junit.main.LaunchResult;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.keycloak.it.junit5.extension.BeforeStartDistribution;
import org.keycloak.it.junit5.extension.CLIResult;
import org.keycloak.it.junit5.extension.DatabaseContainer;
import org.keycloak.it.junit5.extension.DistributionTest;
import org.keycloak.it.junit5.extension.DistributionType;
import org.keycloak.it.junit5.extension.DryRun;
import org.keycloak.it.junit5.extension.InfinispanContainer;
import org.keycloak.it.junit5.extension.KeepServerAlive;
import org.keycloak.it.junit5.extension.KeycloakDistributionDecorator;
import org.keycloak.it.junit5.extension.Storage;
import org.keycloak.it.junit5.extension.TestProvider;
import org.keycloak.it.junit5.extension.WithDatabase;
import org.keycloak.it.junit5.extension.WithEnvVars;
import org.keycloak.it.junit5.extension.WithExternalInfinispan;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.it.utils.RawDistRootPath;
import org.keycloak.it.utils.RawKeycloakDistribution;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.test.TestConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;

public class CLITestExtension
extends QuarkusMainTestExtension {
    private static final String SYS_PROPS = "sys-props";
    private KeycloakDistribution dist;
    private DatabaseContainer databaseContainer;
    private InfinispanContainer infinispanContainer;
    private CLIResult result;

    public void beforeEach(ExtensionContext context) throws Exception {
        DistributionTest distConfig = this.getDistributionConfig(context);
        Launch launch = context.getRequiredTestMethod().getAnnotation(Launch.class);
        this.getStore(context).put((Object)SYS_PROPS, new HashMap<Object, Object>(System.getProperties()));
        if (launch != null && distConfig == null) {
            ConfigArgsConfigSource.parseConfigArgs(List.of(launch.value()), (arg, value) -> {
                if (arg.equals("-cf") || arg.equals("--config-file")) {
                    System.setProperty("kc.config.file", value);
                } else if (arg.startsWith("-D")) {
                    System.setProperty(arg, value);
                }
            }, arg -> {
                if (arg.startsWith("-D")) {
                    System.setProperty(arg, "");
                }
            });
        }
        this.configureDatabase(context);
        this.infinispanContainer = CLITestExtension.configureExternalInfinispan(context);
        if (distConfig != null) {
            boolean dryRun;
            if (this.dist == null) {
                this.dist = this.createDistribution(distConfig, CLITestExtension.getStoreConfig(context), CLITestExtension.getDatabaseConfig(context));
            }
            this.onKeepServerAlive(context.getRequiredTestMethod().getAnnotation(KeepServerAlive.class), true);
            this.copyTestProvider(context.getRequiredTestClass().getAnnotation(TestProvider.class));
            this.copyTestProvider(context.getRequiredTestMethod().getAnnotation(TestProvider.class));
            this.onBeforeStartDistribution(context.getRequiredTestClass().getAnnotation(BeforeStartDistribution.class));
            this.onBeforeStartDistribution(context.getRequiredTestMethod().getAnnotation(BeforeStartDistribution.class));
            this.configureEnvVars(context.getRequiredTestClass().getAnnotation(WithEnvVars.class));
            this.configureEnvVars(context.getRequiredTestMethod().getAnnotation(WithEnvVars.class));
            boolean bl = dryRun = context.getRequiredTestClass().getAnnotation(DryRun.class) != null || context.getRequiredTestMethod().getAnnotation(DryRun.class) != null;
            if (dryRun && this.isRaw()) {
                this.dist.setEnvVar("KC_DRY_RUN", "true");
                this.dist.setEnvVar("KC_DRY_RUN_BUILD", "true");
            }
            if (launch != null) {
                this.result = this.dist.run(Stream.concat(List.of(launch.value()).stream(), List.of(distConfig.defaultOptions()).stream()).collect(Collectors.toList()));
            }
        } else {
            ConfigArgsConfigSource.setCliArgs((String[])(launch == null ? new String[]{} : launch.value()));
            this.configureProfile(context);
            super.beforeEach(context);
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass(), context.getRequiredTestMethod()}));
    }

    private static Storage getStoreConfig(ExtensionContext context) {
        return ((Class)context.getTestClass().get()).getDeclaredAnnotation(Storage.class);
    }

    private void copyTestProvider(TestProvider provider) {
        if (provider == null) {
            return;
        }
        if (this.isRaw()) {
            try {
                this.dist.unwrap(RawKeycloakDistribution.class).copyProvider(provider.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to instantiate test provider: " + provider.getClass(), cause);
            }
        }
    }

    private boolean isRaw() {
        return DistributionType.RAW.equals((Object)DistributionType.getCurrent().orElse(DistributionType.RAW));
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.dist == null) {
            super.interceptTestMethod(invocation, invocationContext, extensionContext);
        } else {
            invocation.proceed();
        }
    }

    private void onBeforeStartDistribution(BeforeStartDistribution annotation) {
        if (annotation != null) {
            try {
                annotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).accept(this.dist);
            }
            catch (Exception cause) {
                throw new RuntimeException("Error when invoking " + annotation.value() + " instance before starting distribution", cause);
            }
        }
    }

    private void onKeepServerAlive(KeepServerAlive annotation, boolean setting) {
        if (annotation != null && this.dist != null) {
            try {
                this.dist.setManualStop(setting);
            }
            catch (Exception cause) {
                throw new RuntimeException("Error when invoking " + annotation, cause);
            }
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        DistributionTest distConfig = this.getDistributionConfig(context);
        if (this.dist != null) {
            this.onKeepServerAlive(context.getRequiredTestMethod().getAnnotation(KeepServerAlive.class), false);
            this.dist.stop();
            this.dist.clearEnv();
            if (distConfig != null && DistributionTest.ReInstall.BEFORE_TEST.equals((Object)distConfig.reInstall())) {
                this.dist = null;
            }
        }
        super.afterEach(context);
        this.reset(distConfig, context);
    }

    private void reset(DistributionTest distConfig, ExtensionContext context) {
        QuarkusConfigFactory.setConfig(null);
        HashMap props = (HashMap)this.getStore(context).remove((Object)SYS_PROPS, HashMap.class);
        System.getProperties().clear();
        System.getProperties().putAll((Map<?, ?>)props);
        TestConfigArgsConfigSource.setCliArgs((String[])new String[0]);
        if (this.databaseContainer != null && this.databaseContainer.isRunning()) {
            this.databaseContainer.stop();
            this.databaseContainer = null;
        }
        if (this.infinispanContainer != null) {
            this.infinispanContainer.stop();
        }
        this.result = null;
        if (this.isRaw() && distConfig != null && !DistributionTest.ReInstall.NEVER.equals((Object)distConfig.reInstall()) && this.dist != null) {
            try {
                FileUtil.deleteDirectory((Path)this.getDistPath().getDistRootPath().resolve("conf"));
                this.getDistPath().getDistRootPath().resolve("conf").toFile().mkdirs();
                FileUtil.deleteDirectory((Path)this.getDistPath().getDistRootPath().resolve("providers"));
                this.getDistPath().getDistRootPath().resolve("providers").toFile().mkdirs();
                FileUtil.deleteDirectory((Path)this.getDistPath().getDistRootPath().resolve("data"));
                this.getDistPath().getDistRootPath().resolve("data").toFile().mkdirs();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete conf directory");
            }
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        DistributionTest distConfig = this.getDistributionConfig(context);
        if (distConfig != null) {
            if (DistributionTest.ReInstall.BEFORE_ALL.equals((Object)distConfig.reInstall())) {
                this.dist = this.createDistribution(distConfig, CLITestExtension.getStoreConfig(context), CLITestExtension.getDatabaseConfig(context));
            }
        } else {
            Environment.forceTestLaunchMode();
        }
        super.beforeAll(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.dist != null) {
            this.dist.stop();
        }
        super.afterAll(context);
    }

    private KeycloakDistribution createDistribution(DistributionTest config, Storage storeConfig, WithDatabase databaseConfig) {
        return new KeycloakDistributionDecorator(storeConfig, databaseConfig, config, DistributionType.getCurrent().orElse(DistributionType.RAW).newInstance(config));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        if (type == LaunchResult.class || type == CLIResult.class) {
            boolean isDistribution;
            boolean bl = isDistribution = this.getDistributionConfig(context) != null;
            if (isDistribution) {
                return this.result;
            }
            LaunchResult result = (LaunchResult)super.resolveParameter(parameterContext, context);
            List outputStream = result.getOutputStream();
            List errStream = result.getErrorStream();
            int exitCode = result.exitCode();
            return CLIResult.create(outputStream, errStream, exitCode);
        }
        if (type.equals(RawDistRootPath.class)) {
            return this.getDistPath();
        }
        if (type.equals(KeycloakDistribution.class)) {
            if (context.getTestClass().orElse(Object.class).getDeclaredAnnotation(DistributionTest.class) == null) {
                throw new RuntimeException("Only tests annotated with " + DistributionTest.class + " can inject a distribution instance");
            }
            return this.dist;
        }
        throw new RuntimeException("Parameter type [" + type + "] not supported");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return type == LaunchResult.class || type == CLIResult.class || type == RawDistRootPath.class || type == KeycloakDistribution.class;
    }

    private void configureProfile(ExtensionContext context) {
        List<String> cliArgs = this.getCliArgs(context);
        if (cliArgs.contains("start")) {
            Environment.setProfile((String)"prod");
        } else if (cliArgs.contains("start-dev")) {
            Environment.forceDevProfile();
        }
    }

    private void configureDatabase(ExtensionContext context) {
        WithDatabase database = CLITestExtension.getDatabaseConfig(context);
        if (database != null) {
            if (this.dist == null) {
                this.configureDevServices();
                System.setProperty("kc.db", database.alias());
                System.setProperty("kc.db-password", "Password1!");
            } else {
                this.databaseContainer = new DatabaseContainer(database.alias());
                this.databaseContainer.start();
                if (database.buildOptions().length == 0) {
                    this.dist.setProperty("db", database.alias());
                } else {
                    for (String option : database.buildOptions()) {
                        this.dist.setProperty(option.substring(0, option.indexOf(61)), option.substring(option.indexOf(61) + 1));
                    }
                }
                this.databaseContainer.configureDistribution(this.dist);
                this.dist.run("build");
            }
        } else {
            System.setProperty("kc.db-url-path", new QuarkusPlatform().getTmpDirectory().getAbsolutePath());
        }
    }

    private static InfinispanContainer configureExternalInfinispan(ExtensionContext context) {
        if (CLITestExtension.getAnnotationFromTestContext(context, WithExternalInfinispan.class) != null) {
            InfinispanContainer infinispanContainer = new InfinispanContainer();
            infinispanContainer.start();
            return infinispanContainer;
        }
        return null;
    }

    private static WithDatabase getDatabaseConfig(ExtensionContext context) {
        return CLITestExtension.getAnnotationFromTestContext(context, WithDatabase.class);
    }

    private static <T extends Annotation> T getAnnotationFromTestContext(ExtensionContext context, Class<T> annotationClass) {
        return (T)((Annotation)context.getTestClass().map(c -> c.getDeclaredAnnotation(annotationClass)).or(() -> context.getTestMethod().map(m -> m.getAnnotation(annotationClass))).orElse(null));
    }

    private void configureDevServices() {
        System.setProperty("quarkus.vault.devservices.enabled", Boolean.FALSE.toString());
        System.setProperty("quarkus.datasource.devservices.enabled", Boolean.TRUE.toString());
        System.setProperty("quarkus.devservices.enabled", Boolean.TRUE.toString());
    }

    private void configureEnvVars(WithEnvVars envVars) {
        if (envVars == null) {
            return;
        }
        for (int i = 0; i < envVars.value().length; i += 2) {
            this.dist.setEnvVar(envVars.value()[i], envVars.value()[i + 1]);
        }
    }

    private List<String> getCliArgs(ExtensionContext context) {
        Launch annotation = context.getRequiredTestMethod().getAnnotation(Launch.class);
        if (annotation != null) {
            return Arrays.asList(annotation.value());
        }
        return Collections.emptyList();
    }

    private DistributionTest getDistributionConfig(ExtensionContext context) {
        return ((Class)context.getTestClass().get()).getDeclaredAnnotation(DistributionTest.class);
    }

    private RawDistRootPath getDistPath() {
        return new RawDistRootPath(this.dist.unwrap(RawKeycloakDistribution.class).getDistPath());
    }
}

