/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;
import io.restassured.RestAssured;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.it.junit5.extension.CLIResult;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.it.utils.Maven;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.utility.DockerImageName;

public final class DockerKeycloakDistribution
implements KeycloakDistribution {
    private static final Logger LOGGER = Logger.getLogger(DockerKeycloakDistribution.class);
    private final boolean debug;
    private final boolean manualStop;
    private final int requestPort;
    private final Integer[] exposedPorts;
    private int exitCode = -1;
    private String stdout = "";
    private String stderr = "";
    private BackupConsumer backupConsumer = new BackupConsumer();
    private final File dockerScriptFile = new File("../../container/ubi-null.sh");
    private GenericContainer<?> keycloakContainer = null;
    private String containerId = null;
    private final Executor parallelReaperExecutor = Executors.newSingleThreadExecutor();
    private final Map<String, String> envVars = new HashMap<String, String>();

    public DockerKeycloakDistribution(boolean debug, boolean manualStop, int requestPort, int[] exposedPorts) {
        this.debug = debug;
        this.manualStop = manualStop;
        this.requestPort = requestPort;
        this.exposedPorts = (Integer[])IntStream.of(exposedPorts).boxed().toArray(Integer[]::new);
    }

    @Override
    public void setEnvVar(String name, String value) {
        this.envVars.put(name, value);
    }

    private GenericContainer<?> getKeycloakContainer() {
        RemoteDockerImage image;
        File distributionFile = new File("../../dist/" + File.separator + "target" + File.separator + "keycloak-" + Version.VERSION + ".tar.gz");
        if (!distributionFile.exists()) {
            distributionFile = Maven.resolveArtifact("org.keycloak", "keycloak-quarkus-dist").toFile();
        }
        if (!distributionFile.exists()) {
            throw new RuntimeException("Distribution archive " + distributionFile.getAbsolutePath() + " doesn't exist");
        }
        File dockerFile = new File("../../container/Dockerfile");
        if (dockerFile.exists()) {
            image = ((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("keycloak-under-test", false).withFileFromFile("keycloak.tar.gz", distributionFile)).withFileFromFile("ubi-null.sh", this.dockerScriptFile)).withFileFromFile("Dockerfile", dockerFile)).withBuildArg("KEYCLOAK_DIST", "keycloak.tar.gz");
            this.toString();
        } else {
            image = new RemoteDockerImage(DockerImageName.parse((String)"quay.io/keycloak/keycloak"));
        }
        return new GenericContainer((Future)image).withEnv(this.envVars).withExposedPorts(this.exposedPorts).withStartupAttempts(1).withStartupTimeout(Duration.ofSeconds(120L)).waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{8080}));
    }

    @Override
    public CLIResult run(List<String> arguments) {
        this.stop();
        try {
            this.exitCode = -1;
            this.stdout = "";
            this.stderr = "";
            this.containerId = null;
            this.backupConsumer = new BackupConsumer();
            this.keycloakContainer = this.getKeycloakContainer();
            this.keycloakContainer.withLogConsumer((Consumer)this.backupConsumer).withCommand(arguments.toArray(new String[0])).start();
            this.containerId = this.keycloakContainer.getContainerId();
            this.waitForStableOutput();
        }
        catch (Exception cause) {
            this.exitCode = -1;
            this.stdout = this.backupConsumer.stdOut.toUtf8String();
            this.stderr = this.backupConsumer.stdErr.toUtf8String();
            this.cleanupContainer();
            this.keycloakContainer = null;
            LOGGER.warn((Object)"Failed to start Keycloak container", (Throwable)cause);
        }
        finally {
            if (!this.manualStop) {
                this.stop();
            }
        }
        this.setRequestPort();
        return CLIResult.create(this.getOutputStream(), this.getErrorStream(), this.getExitCode());
    }

    @Override
    public void setRequestPort() {
        this.setRequestPort(this.requestPort);
    }

    @Override
    public void setRequestPort(int port) {
        if (this.keycloakContainer != null) {
            RestAssured.port = this.keycloakContainer.getMappedPort(port);
        }
    }

    private void waitForStableOutput() {
        int retry = 10;
        String lastLine = "";
        boolean stableOutput = false;
        while (!stableOutput) {
            if (this.keycloakContainer.isRunning()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                String[] splitted = this.keycloakContainer.getLogs().split(System.lineSeparator());
                String newLastLine = splitted[splitted.length - 1];
                stableOutput = lastLine.equals(newLastLine) | --retry <= 0;
                lastLine = newLastLine;
                continue;
            }
            stableOutput = true;
        }
    }

    @Override
    public void stop() {
        try {
            if (this.keycloakContainer != null) {
                this.containerId = this.keycloakContainer.getContainerId();
                this.stdout = this.fetchOutputStream();
                this.stderr = this.fetchErrorStream();
                this.keycloakContainer.stop();
                this.exitCode = 0;
            }
        }
        catch (Exception cause) {
            this.exitCode = -1;
            throw new RuntimeException("Failed to stop the server", cause);
        }
        finally {
            this.cleanupContainer();
            this.keycloakContainer = null;
        }
    }

    private void cleanupContainer() {
        if (this.containerId != null) {
            try {
                Runnable reaper = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (DockerKeycloakDistribution.this.containerId == null) {
                                return;
                            }
                            DockerClient dockerClient = DockerClientFactory.lazyClient();
                            dockerClient.killContainerCmd(DockerKeycloakDistribution.this.containerId).exec();
                            dockerClient.removeContainerCmd(DockerKeycloakDistribution.this.containerId).withRemoveVolumes(Boolean.valueOf(true)).withForce(Boolean.valueOf(true)).exec();
                        }
                        catch (NotFoundException notFound) {
                            LOGGER.debug((Object)"Container is already cleaned up, no additional cleanup required");
                        }
                        catch (Exception cause) {
                            throw new RuntimeException("Failed to stop and remove container", cause);
                        }
                    }
                };
                this.parallelReaperExecutor.execute(reaper);
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to schecdule the removal of the container", cause);
            }
        }
    }

    private String fetchOutputStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDOUT});
        }
        if (this.stdout.isEmpty()) {
            return this.backupConsumer.stdOut.toUtf8String();
        }
        return this.stdout;
    }

    @Override
    public List<String> getOutputStream() {
        return List.of(this.fetchOutputStream().split("\n"));
    }

    public String fetchErrorStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDERR});
        }
        if (this.stderr.isEmpty()) {
            return this.backupConsumer.stdErr.toUtf8String();
        }
        return this.stderr;
    }

    @Override
    public List<String> getErrorStream() {
        return List.of(this.fetchErrorStream().split("\n"));
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isManualStop() {
        return this.manualStop;
    }

    @Override
    public <D extends KeycloakDistribution> D unwrap(Class<D> type) {
        if (!KeycloakDistribution.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Not a " + KeycloakDistribution.class + " type");
        }
        if (type.isInstance(this)) {
            return (D)((KeycloakDistribution)type.cast(this));
        }
        throw new IllegalArgumentException("Not a " + type + " type");
    }

    @Override
    public void clearEnv() {
        this.envVars.clear();
    }

    private static class BackupConsumer
    implements Consumer<OutputFrame> {
        final ToStringConsumer stdOut = new ToStringConsumer();
        final ToStringConsumer stdErr = new ToStringConsumer();

        private BackupConsumer() {
        }

        @Override
        public void accept(OutputFrame t) {
            if (t.getType() == OutputFrame.OutputType.STDERR) {
                this.stdErr.accept(t);
            } else if (t.getType() == OutputFrame.OutputType.STDOUT) {
                this.stdOut.accept(t);
            }
        }
    }
}

