/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.time.Duration;
import org.keycloak.it.utils.KeycloakDistribution;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class DatabaseContainer {
    static final String DEFAULT_PASSWORD = "Password1!";
    private final String alias;
    private GenericContainer<?> container;

    DatabaseContainer(String alias) {
        this.alias = alias;
    }

    void start() {
        this.container = this.createContainer();
        this.container.withStartupTimeout(Duration.ofMinutes(5L)).start();
    }

    boolean isRunning() {
        return this.container.isRunning();
    }

    void configureDistribution(KeycloakDistribution dist) {
        dist.setProperty("db-username", this.getUsername());
        dist.setProperty("db-password", this.getPassword());
        dist.setProperty("db-url", this.getJdbcUrl());
    }

    private String getJdbcUrl() {
        return ((JdbcDatabaseContainer)this.container).getJdbcUrl();
    }

    String getUsername() {
        if (this.container instanceof MSSQLServerContainer) {
            return ((JdbcDatabaseContainer)this.container).getUsername();
        }
        return "keycloak";
    }

    String getPassword() {
        if (this.container instanceof MSSQLServerContainer) {
            return ((JdbcDatabaseContainer)this.container).getPassword();
        }
        return DEFAULT_PASSWORD;
    }

    void stop() {
        this.container.stop();
        this.container = null;
    }

    private JdbcDatabaseContainer configureJdbcContainer(JdbcDatabaseContainer jdbcDatabaseContainer) {
        if (jdbcDatabaseContainer instanceof MSSQLServerContainer) {
            return jdbcDatabaseContainer;
        }
        return jdbcDatabaseContainer.withDatabaseName("keycloak").withUsername(this.getUsername()).withPassword(this.getPassword()).withInitScript(this.resolveInitScript());
    }

    private GenericContainer<?> createContainer() {
        String POSTGRES_IMAGE = System.getProperty("kc.db.postgresql.container.image");
        String MARIADB_IMAGE = System.getProperty("kc.db.mariadb.container.image");
        String MYSQL_IMAGE = System.getProperty("kc.db.mysql.container.image");
        String MSSQL_IMAGE = System.getProperty("kc.db.mssql.container.image");
        switch (this.alias) {
            case "postgres": {
                DockerImageName POSTGRES = DockerImageName.parse((String)POSTGRES_IMAGE).asCompatibleSubstituteFor("postgres");
                return this.configureJdbcContainer((JdbcDatabaseContainer)new PostgreSQLContainer(POSTGRES));
            }
            case "mariadb": {
                DockerImageName MARIADB = DockerImageName.parse((String)MARIADB_IMAGE).asCompatibleSubstituteFor("mariadb");
                return this.configureJdbcContainer((JdbcDatabaseContainer)new MariaDBContainer(MARIADB));
            }
            case "mysql": {
                DockerImageName MYSQL = DockerImageName.parse((String)MYSQL_IMAGE).asCompatibleSubstituteFor("mysql");
                return this.configureJdbcContainer((JdbcDatabaseContainer)new MySQLContainer(MYSQL));
            }
            case "mssql": {
                DockerImageName MSSQL = DockerImageName.parse((String)MSSQL_IMAGE).asCompatibleSubstituteFor("sqlserver");
                return this.configureJdbcContainer((JdbcDatabaseContainer)new MSSQLServerContainer(MSSQL));
            }
        }
        throw new RuntimeException("Unsupported database: " + this.alias);
    }

    private String resolveInitScript() {
        return String.format("database/scripts/init-%s.sql", this.alias);
    }
}

