/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.test;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.KeycloakConfigSourceProvider;
import org.keycloak.quarkus.runtime.configuration.test.TestConfigArgsConfigSource;

public class TestKeycloakConfigSourceProvider
extends KeycloakConfigSourceProvider {
    private static final Map<Class<? extends ConfigSource>, Supplier<? extends ConfigSource>> REPLACEABLE_CONFIG_SOURCES = new HashMap<Class<? extends ConfigSource>, Supplier<? extends ConfigSource>>();

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        TestKeycloakConfigSourceProvider.reload();
        return StreamSupport.stream(super.getConfigSources(forClassLoader).spliterator(), false).map(new Function<ConfigSource, ConfigSource>(){

            @Override
            public ConfigSource apply(ConfigSource configSource) {
                return REPLACEABLE_CONFIG_SOURCES.getOrDefault(configSource.getClass(), () -> configSource).get();
            }
        }).collect(Collectors.toList());
    }

    static {
        REPLACEABLE_CONFIG_SOURCES.put(ConfigArgsConfigSource.class, TestConfigArgsConfigSource::new);
    }
}

