/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.util.Optional;
import java.util.function.Function;
import org.keycloak.it.junit5.extension.DistributionTest;
import org.keycloak.it.utils.DockerKeycloakDistribution;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.it.utils.RawKeycloakDistribution;
import org.keycloak.utils.StringUtil;

public enum DistributionType {
    RAW(DistributionType::createRawDistribution),
    DOCKER(DistributionType::createDockerDistribution);

    private final Function<DistributionTest, KeycloakDistribution> factory;

    private static KeycloakDistribution createDockerDistribution(DistributionTest config) {
        return new DockerKeycloakDistribution(config.debug(), config.keepAlive(), config.requestPort(), config.containerExposedPorts());
    }

    private static KeycloakDistribution createRawDistribution(DistributionTest config) {
        return new RawKeycloakDistribution(config.debug(), config.keepAlive(), config.enableTls(), !DistributionTest.ReInstall.NEVER.equals((Object)config.reInstall()), config.removeBuildOptionsAfterBuild(), config.requestPort());
    }

    private DistributionType(Function<DistributionTest, KeycloakDistribution> factory) {
        this.factory = factory;
    }

    public static Optional<DistributionType> getCurrent() {
        String distributionType = System.getProperty("kc.quarkus.tests.dist");
        if (StringUtil.isBlank((String)distributionType)) {
            return Optional.empty();
        }
        try {
            return Optional.of(DistributionType.valueOf(distributionType.toUpperCase()));
        }
        catch (IllegalStateException cause) {
            throw new RuntimeException("Invalid distribution type: " + distributionType);
        }
    }

    public static boolean isContainerDist() {
        return DistributionType.getCurrent().map(f -> f.equals((Object)DOCKER)).orElse(false);
    }

    public static boolean isRawDist() {
        return DistributionType.getCurrent().map(f -> f.equals((Object)RAW)).orElse(false);
    }

    public KeycloakDistribution newInstance(DistributionTest config) {
        return this.factory.apply(config);
    }
}

