/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;
import io.restassured.RestAssured;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.it.junit5.extension.CLIResult;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.it.utils.Maven;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LazyFuture;
import org.testcontainers.utility.MountableFile;

public final class DockerKeycloakDistribution
implements KeycloakDistribution {
    private static final Logger LOGGER = Logger.getLogger(DockerKeycloakDistribution.class);
    public static final int STARTUP_TIMEOUT_SECONDS = 120;
    private final boolean debug;
    private final boolean manualStop;
    private final int requestPort;
    private final Integer[] exposedPorts;
    private int exitCode = -1;
    private String stdout = "";
    private String stderr = "";
    private BackupConsumer backupConsumer;
    private Consumer<OutputFrame> customLogConsumer;
    private GenericContainer<?> keycloakContainer = null;
    private String containerId = null;
    private final Executor parallelReaperExecutor = Executors.newSingleThreadExecutor();
    private final Map<String, String> envVars = new HashMap<String, String>();
    private final LazyFuture<String> image;
    private final Map<MountableFile, String> copyToContainer = new HashMap<MountableFile, String>();

    public DockerKeycloakDistribution(boolean debug, boolean manualStop, int requestPort, int[] exposedPorts) {
        this(debug, manualStop, requestPort, exposedPorts, null);
    }

    public DockerKeycloakDistribution(boolean debug, boolean manualStop, int requestPort, int[] exposedPorts, LazyFuture<String> image) {
        this.debug = debug;
        this.manualStop = manualStop;
        this.requestPort = requestPort;
        this.exposedPorts = (Integer[])IntStream.of(exposedPorts).boxed().toArray(Integer[]::new);
        this.image = image == null ? DockerKeycloakDistribution.createImage(false) : image;
    }

    @Override
    public void setEnvVar(String name, String value) {
        this.envVars.put(name, value);
    }

    public void setCustomLogConsumer(Consumer<OutputFrame> customLogConsumer) {
        this.customLogConsumer = customLogConsumer;
    }

    private GenericContainer<?> getKeycloakContainer() {
        return new GenericContainer(this.image).withEnv(this.envVars).withExposedPorts(this.exposedPorts).withStartupAttempts(1).withStartupTimeout(Duration.ofSeconds(120L)).waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{8080}));
    }

    public static LazyFuture<String> createImage(boolean failIfDockerFileMissing) {
        Path quarkusModule = Maven.getKeycloakQuarkusModulePath();
        File distributionFile = quarkusModule.resolve(Path.of("dist", "target", "keycloak-" + Version.VERSION + ".tar.gz")).toFile();
        if (!distributionFile.exists()) {
            throw new RuntimeException("Distribution archive " + distributionFile.getAbsolutePath() + " doesn't exist");
        }
        LOGGER.infof("Building a new docker image from distribution: %s", (Object)distributionFile.getAbsoluteFile());
        File dockerFile = quarkusModule.resolve(Path.of("container", "Dockerfile")).toFile();
        File ubiNullScript = quarkusModule.resolve(Path.of("container", "ubi-null.sh")).toFile();
        if (dockerFile.exists()) {
            return ((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("keycloak-under-test", false).withFileFromFile("keycloak.tar.gz", distributionFile)).withFileFromFile("ubi-null.sh", ubiNullScript)).withFileFromFile("Dockerfile", dockerFile)).withBuildArg("KEYCLOAK_DIST", "keycloak.tar.gz");
        }
        if (failIfDockerFileMissing) {
            throw new RuntimeException("Docker file %s not found".formatted(dockerFile.getAbsolutePath()));
        }
        return new RemoteDockerImage(DockerImageName.parse((String)"quay.io/keycloak/keycloak"));
    }

    @Override
    public CLIResult run(List<String> arguments) {
        this.stop();
        try {
            this.exitCode = -1;
            this.stdout = "";
            this.stderr = "";
            this.containerId = null;
            this.backupConsumer = new BackupConsumer(this.customLogConsumer);
            this.keycloakContainer = this.getKeycloakContainer();
            this.copyToContainer.forEach((arg_0, arg_1) -> this.keycloakContainer.withCopyFileToContainer(arg_0, arg_1));
            this.keycloakContainer.withLogConsumer((Consumer)this.backupConsumer).withCommand(arguments.toArray(new String[0])).start();
            this.containerId = this.keycloakContainer.getContainerId();
            this.waitForStableOutput();
        }
        catch (Exception cause) {
            this.exitCode = -1;
            this.stdout = this.backupConsumer.stdOut.toUtf8String();
            this.stderr = this.backupConsumer.stdErr.toUtf8String();
            this.cleanupContainer();
            this.keycloakContainer = null;
            LOGGER.warn((Object)"Failed to start Keycloak container", (Throwable)cause);
        }
        finally {
            if (!this.manualStop) {
                this.stop();
            }
        }
        this.setRequestPort();
        return CLIResult.create(this.getOutputStream(), this.getErrorStream(), this.getExitCode());
    }

    @Override
    public void setRequestPort() {
        this.setRequestPort(this.requestPort);
    }

    @Override
    public void setRequestPort(int port) {
        if (this.keycloakContainer != null) {
            RestAssured.port = this.keycloakContainer.getMappedPort(port);
        }
    }

    public void copyProvider(String groupId, String artifactId) {
        Path providerPath = Maven.resolveArtifact(groupId, artifactId);
        if (!Files.isRegularFile(providerPath, new LinkOption[0])) {
            throw new RuntimeException("Failed to copy JAR file to 'providers' directory; " + String.valueOf(providerPath) + " is not a file");
        }
        this.copyToContainer.put(MountableFile.forHostPath((Path)providerPath), "/opt/keycloak/providers/" + String.valueOf(providerPath.getFileName()));
    }

    public void copyConfigFile(Path configFilePath) {
        this.copyToContainer.put(MountableFile.forHostPath((Path)configFilePath), "/opt/keycloak/conf/" + String.valueOf(configFilePath.getFileName()));
    }

    private void waitForStableOutput() {
        int retry = 10;
        String lastLine = "";
        boolean stableOutput = false;
        while (!stableOutput) {
            if (this.keycloakContainer.isRunning()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                String[] splitted = this.keycloakContainer.getLogs().split(System.lineSeparator());
                String newLastLine = splitted[splitted.length - 1];
                stableOutput = lastLine.equals(newLastLine) || --retry <= 0;
                lastLine = newLastLine;
                continue;
            }
            stableOutput = true;
        }
    }

    @Override
    public void stop() {
        try {
            if (this.keycloakContainer != null) {
                this.containerId = this.keycloakContainer.getContainerId();
                this.stdout = this.fetchOutputStream();
                this.stderr = this.fetchErrorStream();
                this.keycloakContainer.stop();
                this.exitCode = 0;
            }
        }
        catch (Exception cause) {
            this.exitCode = -1;
            throw new RuntimeException("Failed to stop the server", cause);
        }
        finally {
            this.cleanupContainer();
            this.keycloakContainer = null;
        }
    }

    private void cleanupContainer() {
        if (this.containerId != null) {
            try {
                Runnable reaper = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (DockerKeycloakDistribution.this.containerId == null) {
                                return;
                            }
                            DockerClient dockerClient = DockerClientFactory.lazyClient();
                            dockerClient.killContainerCmd(DockerKeycloakDistribution.this.containerId).exec();
                            dockerClient.removeContainerCmd(DockerKeycloakDistribution.this.containerId).withRemoveVolumes(Boolean.valueOf(true)).withForce(Boolean.valueOf(true)).exec();
                        }
                        catch (NotFoundException notFound) {
                            LOGGER.debug((Object)"Container is already cleaned up, no additional cleanup required");
                        }
                        catch (Exception cause) {
                            throw new RuntimeException("Failed to stop and remove container", cause);
                        }
                    }
                };
                this.parallelReaperExecutor.execute(reaper);
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to schedule the removal of the container", cause);
            }
        }
    }

    private String fetchOutputStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDOUT});
        }
        if (this.stdout.isEmpty()) {
            return this.backupConsumer.stdOut.toUtf8String();
        }
        return this.stdout;
    }

    @Override
    public List<String> getOutputStream() {
        return List.of(this.fetchOutputStream().split("\n"));
    }

    public String fetchErrorStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDERR});
        }
        if (this.stderr.isEmpty()) {
            return this.backupConsumer.stdErr.toUtf8String();
        }
        return this.stderr;
    }

    @Override
    public List<String> getErrorStream() {
        return List.of(this.fetchErrorStream().split("\n"));
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isManualStop() {
        return this.manualStop;
    }

    @Override
    public <D extends KeycloakDistribution> D unwrap(Class<D> type) {
        if (!KeycloakDistribution.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Not a " + String.valueOf(KeycloakDistribution.class) + " type");
        }
        if (type.isInstance(this)) {
            return (D)((KeycloakDistribution)type.cast(this));
        }
        throw new IllegalArgumentException("Not a " + String.valueOf(type) + " type");
    }

    @Override
    public void clearEnv() {
        this.envVars.clear();
    }

    public int getMappedPort(int port) {
        if (this.keycloakContainer == null || !this.keycloakContainer.isRunning()) {
            throw new IllegalStateException("KeycloakContainer is not running.");
        }
        return this.keycloakContainer.getMappedPort(port);
    }

    private static class BackupConsumer
    implements Consumer<OutputFrame> {
        final ToStringConsumer stdOut = new ToStringConsumer();
        final ToStringConsumer stdErr = new ToStringConsumer();
        final Consumer<OutputFrame> customLogConsumer;

        public BackupConsumer(Consumer<OutputFrame> customLogConsumer) {
            this.customLogConsumer = customLogConsumer;
        }

        @Override
        public void accept(OutputFrame t) {
            if (this.customLogConsumer != null) {
                this.customLogConsumer.accept(t);
            }
            if (t.getType() == OutputFrame.OutputType.STDERR) {
                this.stdErr.accept(t);
            } else if (t.getType() == OutputFrame.OutputType.STDOUT) {
                this.stdOut.accept(t);
            }
        }
    }
}

