/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.initializer.InfinispanUserSessionInitializer;
import org.keycloak.models.sessions.infinispan.initializer.OfflineUserSessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    private Config.Scope config;

    public UserSessionProvider create(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("sessions");
        Cache offlineSessionsCache = connections.getCache("offlineSessions");
        Cache loginFailures = connections.getCache("loginFailures");
        return new InfinispanUserSessionProvider(session, cache, offlineSessionsCache, loginFailures);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(final KeycloakSessionFactory factory) {
        final int maxErrors = this.config.getInt("maxErrors", Integer.valueOf(20));
        final int sessionsPerSegment = this.config.getInt("sessionsPerSegment", Integer.valueOf(100));
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof PostMigrationEvent) {
                    InfinispanUserSessionProviderFactory.this.loadPersistentSessions(factory, maxErrors, sessionsPerSegment);
                }
            }
        });
    }

    public void loadPersistentSessions(final KeycloakSessionFactory sessionFactory, final int maxErrors, final int sessionsPerSegment) {
        log.debug((Object)"Start pre-loading userSessions and clientSessions from persistent storage");
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                Cache cache = connections.getCache("offlineSessions");
                InfinispanUserSessionInitializer initializer = new InfinispanUserSessionInitializer(sessionFactory, cache, new OfflineUserSessionLoader(), maxErrors, sessionsPerSegment, "offlineUserSessions");
                initializer.initCache();
                initializer.loadPersistentSessions();
            }
        });
        log.debug((Object)"Pre-loading userSessions and clientSessions from persistent storage finished");
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

