/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedClientTemplate
extends AbstractRevisioned
implements InRealm {
    private String name;
    private String description;
    private String realm;
    private String protocol;
    private boolean fullScopeAllowed;
    private boolean publicClient;
    private boolean frontchannelLogout;
    private boolean bearerOnly;
    private boolean consentRequired;
    private boolean standardFlowEnabled;
    private boolean implicitFlowEnabled;
    private boolean directAccessGrantsEnabled;
    private boolean serviceAccountsEnabled;
    private Set<String> scope = new HashSet<String>();
    private Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
    private Map<String, String> attributes = new HashMap<String, String>();

    public CachedClientTemplate(Long revision, RealmModel realm, ClientTemplateModel model) {
        super(revision, model.getId());
        this.name = model.getName();
        this.description = model.getDescription();
        this.realm = realm.getId();
        this.protocol = model.getProtocol();
        this.fullScopeAllowed = model.isFullScopeAllowed();
        for (ProtocolMapperModel mapper : model.getProtocolMappers()) {
            this.protocolMappers.add(mapper);
        }
        for (RoleModel role : model.getScopeMappings()) {
            this.scope.add(role.getId());
        }
        this.attributes.putAll(model.getAttributes());
        this.frontchannelLogout = model.isFrontchannelLogout();
        this.publicClient = model.isPublicClient();
        this.bearerOnly = model.isBearerOnly();
        this.consentRequired = model.isConsentRequired();
        this.standardFlowEnabled = model.isStandardFlowEnabled();
        this.implicitFlowEnabled = model.isImplicitFlowEnabled();
        this.directAccessGrantsEnabled = model.isDirectAccessGrantsEnabled();
        this.serviceAccountsEnabled = model.isServiceAccountsEnabled();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isFullScopeAllowed() {
        return this.fullScopeAllowed;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public boolean isFrontchannelLogout() {
        return this.frontchannelLogout;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public boolean isConsentRequired() {
        return this.consentRequired;
    }

    public boolean isStandardFlowEnabled() {
        return this.standardFlowEnabled;
    }

    public boolean isImplicitFlowEnabled() {
        return this.implicitFlowEnabled;
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.directAccessGrantsEnabled;
    }

    public boolean isServiceAccountsEnabled() {
        return this.serviceAccountsEnabled;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

