/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.infinispan;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.PublicKeyStorageProviderFactory;
import org.keycloak.keys.infinispan.InfinispanPublicKeyStorageProvider;
import org.keycloak.keys.infinispan.PublicKeysEntry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class InfinispanPublicKeyStorageProviderFactory
implements PublicKeyStorageProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanPublicKeyStorageProviderFactory.class);
    public static final String PROVIDER_ID = "infinispan";
    private Cache<String, PublicKeysEntry> keysCache;
    private final Map<String, FutureTask<PublicKeysEntry>> tasksInProgress = new ConcurrentHashMap<String, FutureTask<PublicKeysEntry>>();
    private int minTimeBetweenRequests;

    public PublicKeyStorageProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanPublicKeyStorageProvider(this.keysCache, this.tasksInProgress, this.minTimeBetweenRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.keysCache == null) {
            InfinispanPublicKeyStorageProviderFactory infinispanPublicKeyStorageProviderFactory = this;
            synchronized (infinispanPublicKeyStorageProviderFactory) {
                if (this.keysCache == null) {
                    this.keysCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("keys");
                }
            }
        }
    }

    public void init(Config.Scope config) {
        this.minTimeBetweenRequests = config.getInt("minTimeBetweenRequests", Integer.valueOf(10));
        log.debugf("minTimeBetweenRequests is %d", this.minTimeBetweenRequests);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

