/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

public class GroupAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String groupId;
    private String realmId;

    public static GroupAddedEvent create(String groupId, String realmId) {
        GroupAddedEvent event = new GroupAddedEvent();
        event.realmId = realmId;
        event.groupId = groupId;
        return event;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String toString() {
        return String.format("GroupAddedEvent [ realmId=%s, groupId=%s ]", this.realmId, this.groupId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
    }
}

