/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

public class ClientRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String clientUuid;
    private String clientId;
    private String realmId;
    private Map<String, String> clientRoles;

    public static ClientRemovedEvent create(ClientModel client) {
        ClientRemovedEvent event = new ClientRemovedEvent();
        event.realmId = client.getRealm().getId();
        event.clientUuid = client.getId();
        event.clientId = client.getClientId();
        event.clientRoles = new HashMap<String, String>();
        for (RoleModel clientRole : client.getRoles()) {
            event.clientRoles.put(clientRole.getId(), clientRole.getName());
        }
        return event;
    }

    @Override
    public String getId() {
        return this.clientUuid;
    }

    public String toString() {
        return String.format("ClientRemovedEvent [ realmId=%s, clientUuid=%s, clientId=%s, clientRoleIds=%s ]", this.realmId, this.clientUuid, this.clientId, this.clientRoles);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.clientRemoval(this.realmId, this.clientUuid, this.clientId, invalidations);
        for (Map.Entry<String, String> clientRole : this.clientRoles.entrySet()) {
            String roleId = clientRole.getKey();
            String roleName = clientRole.getValue();
            realmCache.roleRemoval(roleId, roleName, this.clientUuid, invalidations);
        }
    }
}

