/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

public class RoleAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String roleId;
    private String containerId;

    public static RoleAddedEvent create(String roleId, String containerId) {
        RoleAddedEvent event = new RoleAddedEvent();
        event.roleId = roleId;
        event.containerId = containerId;
        return event;
    }

    @Override
    public String getId() {
        return this.roleId;
    }

    public String toString() {
        return String.format("RoleAddedEvent [ roleId=%s, containerId=%s ]", this.roleId, this.containerId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.roleAdded(this.containerId, invalidations);
    }
}

