/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;

public class UserLoginFailureAdapter
implements UserLoginFailureModel {
    private InfinispanUserSessionProvider provider;
    private Cache<LoginFailureKey, LoginFailureEntity> cache;
    private LoginFailureKey key;
    private LoginFailureEntity entity;

    public UserLoginFailureAdapter(InfinispanUserSessionProvider provider, Cache<LoginFailureKey, LoginFailureEntity> cache, LoginFailureKey key, LoginFailureEntity entity) {
        this.provider = provider;
        this.cache = cache;
        this.key = key;
        this.entity = entity;
    }

    public String getUserId() {
        return this.entity.getUserId();
    }

    public int getFailedLoginNotBefore() {
        return this.entity.getFailedLoginNotBefore();
    }

    public void setFailedLoginNotBefore(int notBefore) {
        this.entity.setFailedLoginNotBefore(notBefore);
        this.update();
    }

    public int getNumFailures() {
        return this.entity.getNumFailures();
    }

    public void incrementFailures() {
        this.entity.setNumFailures(this.getNumFailures() + 1);
        this.update();
    }

    public void clearFailures() {
        this.entity.clearFailures();
        this.update();
    }

    public long getLastFailure() {
        return this.entity.getLastFailure();
    }

    public void setLastFailure(long lastFailure) {
        this.entity.setLastFailure(lastFailure);
        this.update();
    }

    public String getLastIPFailure() {
        return this.entity.getLastIPFailure();
    }

    public void setLastIPFailure(String ip) {
        this.entity.setLastIPFailure(ip);
        this.update();
    }

    void update() {
        this.provider.getTx().replace(this.cache, this.key, this.entity);
    }
}

