/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.entities.InScope;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@SerializeWith(value=ExternalizerImpl.class)
public class InScopePredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String scopeId;

    public static InScopePredicate create() {
        return new InScopePredicate();
    }

    public InScopePredicate scope(String id) {
        this.scopeId = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        if (!(value instanceof InScope)) {
            return false;
        }
        return this.scopeId.equals(((InScope)((Object)value)).getScopeId());
    }

    public static class ExternalizerImpl
    implements Externalizer<InScopePredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InScopePredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.scopeId, (ObjectOutput)output);
        }

        public InScopePredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InScopePredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            InScopePredicate res = new InScopePredicate();
            res.scopeId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

