/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.initializer.CacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.InitializerState;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public abstract class BaseCacheInitializer
extends CacheInitializer {
    private static final String STATE_KEY_PREFIX = "distributed::";
    private static final Logger log = Logger.getLogger(BaseCacheInitializer.class);
    protected final KeycloakSessionFactory sessionFactory;
    protected final Cache<String, Serializable> workCache;
    protected final SessionLoader<SessionLoader.LoaderContext, SessionLoader.WorkerContext, SessionLoader.WorkerResult> sessionLoader;
    protected final int sessionsPerSegment;
    protected final String stateKey;

    public BaseCacheInitializer(KeycloakSessionFactory sessionFactory, Cache<String, Serializable> workCache, SessionLoader<SessionLoader.LoaderContext, SessionLoader.WorkerContext, SessionLoader.WorkerResult> sessionLoader, String stateKeySuffix, int sessionsPerSegment) {
        this.sessionFactory = sessionFactory;
        this.workCache = workCache;
        this.sessionLoader = sessionLoader;
        this.sessionsPerSegment = sessionsPerSegment;
        this.stateKey = STATE_KEY_PREFIX + stateKeySuffix;
    }

    @Override
    protected boolean isFinished() {
        boolean isFinishedAlready = this.sessionLoader.isFinished(this);
        if (isFinishedAlready) {
            return true;
        }
        InitializerState state = this.getStateFromCache();
        return state != null && state.isFinished();
    }

    @Override
    protected boolean isCoordinator() {
        Transport transport = this.workCache.getCacheManager().getTransport();
        return transport == null || transport.isCoordinator();
    }

    @Override
    protected int getProgressIndicator() {
        InitializerState state = this.getStateFromCache();
        return state == null ? 0 : state.getProgressIndicator();
    }

    protected InitializerState getStateFromCache() {
        return (InitializerState)this.workCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD}).get((Object)this.stateKey);
    }

    protected void saveStateToCache(final InitializerState state) {
        this.retry(3, new Runnable(){

            @Override
            public void run() {
                BaseCacheInitializer.this.workCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FORCE_SYNCHRONOUS, Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD}).put((Object)BaseCacheInitializer.this.stateKey, (Object)state);
            }
        });
    }

    private void retry(int retry, Runnable runnable) {
        while (true) {
            try {
                runnable.run();
                return;
            }
            catch (RuntimeException e) {
                ComponentStatus status = this.workCache.getStatus();
                if (!status.isStopping() && !status.isTerminated()) continue;
                log.warn((Object)"Failed to put initializerState to the cache. Cache is already terminating");
                log.debug((Object)e.getMessage(), (Throwable)e);
                return;
                if (--retry != 0) continue;
                throw e;
            }
            break;
        }
    }

    public Cache<String, Serializable> getWorkCache() {
        return this.workCache;
    }
}

