/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.ConcurrentMultivaluedHashMap;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.MultivaluedMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ParConfig;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.entities.AbstractExtendableRevisioned;

public class CachedRealm
extends AbstractExtendableRevisioned {
    protected String name;
    protected String displayName;
    protected String displayNameHtml;
    protected boolean enabled;
    protected SslRequired sslRequired;
    protected boolean registrationAllowed;
    protected boolean registrationEmailAsUsername;
    protected boolean rememberMe;
    protected boolean verifyEmail;
    protected boolean loginWithEmailAllowed;
    protected boolean duplicateEmailsAllowed;
    protected boolean resetPasswordAllowed;
    protected boolean identityFederationEnabled;
    protected boolean editUsernameAllowed;
    protected boolean organizationsEnabled;
    protected boolean bruteForceProtected;
    protected boolean permanentLockout;
    protected int maxTemporaryLockouts;
    protected int maxFailureWaitSeconds;
    protected int minimumQuickLoginWaitSeconds;
    protected int waitIncrementSeconds;
    protected long quickLoginCheckMilliSeconds;
    protected int maxDeltaTimeSeconds;
    protected int failureFactor;
    protected String defaultSignatureAlgorithm;
    protected boolean revokeRefreshToken;
    protected int refreshTokenMaxReuse;
    protected int ssoSessionIdleTimeout;
    protected int ssoSessionMaxLifespan;
    protected int ssoSessionIdleTimeoutRememberMe;
    protected int ssoSessionMaxLifespanRememberMe;
    protected int offlineSessionIdleTimeout;
    protected boolean offlineSessionMaxLifespanEnabled;
    protected int offlineSessionMaxLifespan;
    protected int clientSessionIdleTimeout;
    protected int clientSessionMaxLifespan;
    protected int clientOfflineSessionIdleTimeout;
    protected int clientOfflineSessionMaxLifespan;
    protected int accessTokenLifespan;
    protected int accessTokenLifespanForImplicitFlow;
    protected int accessCodeLifespan;
    protected int accessCodeLifespanUserAction;
    protected int accessCodeLifespanLogin;
    protected LazyLoader<RealmModel, OAuth2DeviceConfig> deviceConfig;
    protected LazyLoader<RealmModel, CibaConfig> cibaConfig;
    protected LazyLoader<RealmModel, ParConfig> parConfig;
    protected int actionTokenGeneratedByAdminLifespan;
    protected int actionTokenGeneratedByUserLifespan;
    protected int notBefore;
    protected PasswordPolicy passwordPolicy;
    protected OTPPolicy otpPolicy;
    protected WebAuthnPolicy webAuthnPolicy;
    protected WebAuthnPolicy webAuthnPasswordlessPolicy;
    protected String loginTheme;
    protected String accountTheme;
    protected String adminTheme;
    protected String emailTheme;
    protected String masterAdminClient;
    protected List<RequiredCredentialModel> requiredCredentials;
    protected MultivaluedMap<String, ComponentModel> componentsByParent = new MultivaluedHashMap();
    protected MultivaluedMap<String, ComponentModel> componentsByParentAndType = new ConcurrentMultivaluedHashMap();
    protected Map<String, ComponentModel> components;
    protected Map<String, String> browserSecurityHeaders;
    protected Map<String, String> smtpConfig;
    protected Map<String, AuthenticationFlowModel> authenticationFlows = new HashMap<String, AuthenticationFlowModel>();
    protected List<AuthenticationFlowModel> authenticationFlowList;
    protected Map<String, AuthenticatorConfigModel> authenticatorConfigs;
    protected Map<String, RequiredActionConfigModel> requiredActionProviderConfigs = new HashMap<String, RequiredActionConfigModel>();
    protected Map<String, RequiredActionConfigModel> requiredActionProviderConfigsByAlias = new HashMap<String, RequiredActionConfigModel>();
    protected Map<String, RequiredActionProviderModel> requiredActionProviders = new HashMap<String, RequiredActionProviderModel>();
    protected List<RequiredActionProviderModel> requiredActionProviderList;
    protected Map<String, RequiredActionProviderModel> requiredActionProvidersByAlias = new HashMap<String, RequiredActionProviderModel>();
    protected MultivaluedHashMap<String, AuthenticationExecutionModel> authenticationExecutions = new MultivaluedHashMap();
    protected Map<String, AuthenticationExecutionModel> executionsById = new HashMap<String, AuthenticationExecutionModel>();
    protected Map<String, AuthenticationExecutionModel> executionsByFlowId = new HashMap<String, AuthenticationExecutionModel>();
    protected AuthenticationFlowModel browserFlow;
    protected AuthenticationFlowModel registrationFlow;
    protected AuthenticationFlowModel directGrantFlow;
    protected AuthenticationFlowModel resetCredentialsFlow;
    protected AuthenticationFlowModel clientAuthenticationFlow;
    protected AuthenticationFlowModel dockerAuthenticationFlow;
    protected AuthenticationFlowModel firstBrokerLoginFlow;
    protected boolean eventsEnabled;
    protected long eventsExpiration;
    protected Set<String> eventsListeners;
    protected Set<String> enabledEventTypes;
    protected boolean adminEventsEnabled;
    protected boolean adminEventsDetailsEnabled;
    protected String defaultRoleId;
    private boolean allowUserManagedAccess;
    protected List<String> defaultGroups;
    protected List<String> defaultDefaultClientScopes = new LinkedList<String>();
    protected List<String> optionalDefaultClientScopes = new LinkedList<String>();
    protected boolean internationalizationEnabled;
    protected Set<String> supportedLocales;
    protected String defaultLocale;
    protected Map<String, String> attributes;
    private Map<String, Integer> userActionTokenLifespans;
    protected Map<String, Map<String, String>> realmLocalizationTexts;

    public CachedRealm(Long revision, RealmModel model) {
        super(revision, model.getId());
        this.name = model.getName();
        this.displayName = model.getDisplayName();
        this.displayNameHtml = model.getDisplayNameHtml();
        this.enabled = model.isEnabled();
        this.allowUserManagedAccess = model.isUserManagedAccessAllowed();
        this.sslRequired = model.getSslRequired();
        this.registrationAllowed = model.isRegistrationAllowed();
        this.registrationEmailAsUsername = model.isRegistrationEmailAsUsername();
        this.rememberMe = model.isRememberMe();
        this.verifyEmail = model.isVerifyEmail();
        this.loginWithEmailAllowed = model.isLoginWithEmailAllowed();
        this.duplicateEmailsAllowed = model.isDuplicateEmailsAllowed();
        this.resetPasswordAllowed = model.isResetPasswordAllowed();
        this.editUsernameAllowed = model.isEditUsernameAllowed();
        this.organizationsEnabled = model.isOrganizationsEnabled();
        this.bruteForceProtected = model.isBruteForceProtected();
        this.permanentLockout = model.isPermanentLockout();
        this.maxTemporaryLockouts = model.getMaxTemporaryLockouts();
        this.maxFailureWaitSeconds = model.getMaxFailureWaitSeconds();
        this.minimumQuickLoginWaitSeconds = model.getMinimumQuickLoginWaitSeconds();
        this.waitIncrementSeconds = model.getWaitIncrementSeconds();
        this.quickLoginCheckMilliSeconds = model.getQuickLoginCheckMilliSeconds();
        this.maxDeltaTimeSeconds = model.getMaxDeltaTimeSeconds();
        this.failureFactor = model.getFailureFactor();
        this.defaultSignatureAlgorithm = model.getDefaultSignatureAlgorithm();
        this.revokeRefreshToken = model.isRevokeRefreshToken();
        this.refreshTokenMaxReuse = model.getRefreshTokenMaxReuse();
        this.ssoSessionIdleTimeout = model.getSsoSessionIdleTimeout();
        this.ssoSessionMaxLifespan = model.getSsoSessionMaxLifespan();
        this.ssoSessionIdleTimeoutRememberMe = model.getSsoSessionIdleTimeoutRememberMe();
        this.ssoSessionMaxLifespanRememberMe = model.getSsoSessionMaxLifespanRememberMe();
        this.offlineSessionIdleTimeout = model.getOfflineSessionIdleTimeout();
        this.offlineSessionMaxLifespanEnabled = model.isOfflineSessionMaxLifespanEnabled();
        this.offlineSessionMaxLifespan = model.getOfflineSessionMaxLifespan();
        this.clientSessionIdleTimeout = model.getClientSessionIdleTimeout();
        this.clientSessionMaxLifespan = model.getClientSessionMaxLifespan();
        this.clientOfflineSessionIdleTimeout = model.getClientOfflineSessionIdleTimeout();
        this.clientOfflineSessionMaxLifespan = model.getClientOfflineSessionMaxLifespan();
        this.accessTokenLifespan = model.getAccessTokenLifespan();
        this.accessTokenLifespanForImplicitFlow = model.getAccessTokenLifespanForImplicitFlow();
        this.accessCodeLifespan = model.getAccessCodeLifespan();
        this.deviceConfig = new DefaultLazyLoader<RealmModel, OAuth2DeviceConfig>(OAuth2DeviceConfig::new, null);
        this.cibaConfig = new DefaultLazyLoader<RealmModel, CibaConfig>(CibaConfig::new, null);
        this.parConfig = new DefaultLazyLoader<RealmModel, ParConfig>(ParConfig::new, null);
        this.accessCodeLifespanUserAction = model.getAccessCodeLifespanUserAction();
        this.accessCodeLifespanLogin = model.getAccessCodeLifespanLogin();
        this.actionTokenGeneratedByAdminLifespan = model.getActionTokenGeneratedByAdminLifespan();
        this.actionTokenGeneratedByUserLifespan = model.getActionTokenGeneratedByUserLifespan();
        this.notBefore = model.getNotBefore();
        this.passwordPolicy = model.getPasswordPolicy();
        this.otpPolicy = model.getOTPPolicy();
        this.webAuthnPolicy = model.getWebAuthnPolicy();
        this.webAuthnPasswordlessPolicy = model.getWebAuthnPolicyPasswordless();
        this.loginTheme = model.getLoginTheme();
        this.accountTheme = model.getAccountTheme();
        this.adminTheme = model.getAdminTheme();
        this.emailTheme = model.getEmailTheme();
        this.requiredCredentials = model.getRequiredCredentialsStream().collect(Collectors.toList());
        this.userActionTokenLifespans = Collections.unmodifiableMap(new HashMap(model.getUserActionTokenLifespans()));
        this.smtpConfig = model.getSmtpConfig();
        this.browserSecurityHeaders = model.getBrowserSecurityHeaders();
        this.eventsEnabled = model.isEventsEnabled();
        this.eventsExpiration = model.getEventsExpiration();
        this.eventsListeners = model.getEventsListenersStream().collect(Collectors.toSet());
        this.enabledEventTypes = model.getEnabledEventTypesStream().collect(Collectors.toSet());
        this.adminEventsEnabled = model.isAdminEventsEnabled();
        this.adminEventsDetailsEnabled = model.isAdminEventsDetailsEnabled();
        this.defaultRoleId = model.getDefaultRole().getId();
        ClientModel masterAdminClient = model.getMasterAdminClient();
        this.masterAdminClient = masterAdminClient != null ? masterAdminClient.getId() : null;
        this.cacheClientScopes(model);
        this.internationalizationEnabled = model.isInternationalizationEnabled();
        this.supportedLocales = model.getSupportedLocalesStream().collect(Collectors.toSet());
        this.defaultLocale = model.getDefaultLocale();
        this.authenticationFlowList = model.getAuthenticationFlowsStream().collect(Collectors.toList());
        for (AuthenticationFlowModel flow : this.authenticationFlowList) {
            this.authenticationFlows.put(flow.getId(), flow);
            this.authenticationExecutions.put((Object)flow.getId(), new LinkedList());
            model.getAuthenticationExecutionsStream(flow.getId()).forEachOrdered(execution -> {
                this.authenticationExecutions.add((Object)flow.getId(), execution);
                this.executionsById.put(execution.getId(), (AuthenticationExecutionModel)execution);
                if (execution.getFlowId() != null) {
                    this.executionsByFlowId.put(execution.getFlowId(), (AuthenticationExecutionModel)execution);
                }
            });
        }
        this.authenticatorConfigs = model.getAuthenticatorConfigsStream().collect(Collectors.toMap(AuthenticatorConfigModel::getId, Function.identity()));
        List requiredActionConfigsList = model.getRequiredActionConfigsStream().collect(Collectors.toList());
        for (RequiredActionConfigModel requiredActionConfig : requiredActionConfigsList) {
            this.requiredActionProviderConfigs.put(requiredActionConfig.getId(), requiredActionConfig);
            this.requiredActionProviderConfigsByAlias.put(requiredActionConfig.getAlias(), requiredActionConfig);
        }
        this.requiredActionProviderList = model.getRequiredActionProvidersStream().collect(Collectors.toList());
        for (RequiredActionProviderModel action : this.requiredActionProviderList) {
            this.requiredActionProviders.put(action.getId(), action);
            this.requiredActionProvidersByAlias.put(action.getAlias(), action);
        }
        this.defaultGroups = model.getDefaultGroupsStream().map(GroupModel::getId).collect(Collectors.toList());
        this.browserFlow = model.getBrowserFlow();
        this.registrationFlow = model.getRegistrationFlow();
        this.directGrantFlow = model.getDirectGrantFlow();
        this.resetCredentialsFlow = model.getResetCredentialsFlow();
        this.clientAuthenticationFlow = model.getClientAuthenticationFlow();
        this.dockerAuthenticationFlow = model.getDockerAuthenticationFlow();
        this.firstBrokerLoginFlow = model.getFirstBrokerLoginFlow();
        model.getComponentsStream().forEach(component -> this.componentsByParentAndType.add((Object)(component.getParentId() + component.getProviderType()), component));
        model.getComponentsStream().forEach(component -> this.componentsByParent.add((Object)component.getParentId(), component));
        this.components = model.getComponentsStream().collect(Collectors.toMap(component -> component.getId(), Function.identity()));
        try {
            this.attributes = model.getAttributes();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.realmLocalizationTexts = model.getRealmLocalizationTexts();
    }

    protected void cacheClientScopes(RealmModel model) {
        this.defaultDefaultClientScopes = model.getDefaultClientScopesStream(true).map(ClientScopeModel::getId).collect(Collectors.toList());
        this.optionalDefaultClientScopes = model.getDefaultClientScopesStream(false).map(ClientScopeModel::getId).collect(Collectors.toList());
    }

    public String getMasterAdminClient() {
        return this.masterAdminClient;
    }

    public String getDefaultRoleId() {
        return this.defaultRoleId;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameHtml() {
        return this.displayNameHtml;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SslRequired getSslRequired() {
        return this.sslRequired;
    }

    public boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.registrationEmailAsUsername;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public boolean isBruteForceProtected() {
        return this.bruteForceProtected;
    }

    public boolean isPermanentLockout() {
        return this.permanentLockout;
    }

    public int getMaxTemporaryLockouts() {
        return this.maxTemporaryLockouts;
    }

    public int getMaxFailureWaitSeconds() {
        return this.maxFailureWaitSeconds;
    }

    public int getWaitIncrementSeconds() {
        return this.waitIncrementSeconds;
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.minimumQuickLoginWaitSeconds;
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.quickLoginCheckMilliSeconds;
    }

    public int getMaxDeltaTimeSeconds() {
        return this.maxDeltaTimeSeconds;
    }

    public int getFailureFactor() {
        return this.failureFactor;
    }

    public boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public boolean isLoginWithEmailAllowed() {
        return this.loginWithEmailAllowed;
    }

    public boolean isDuplicateEmailsAllowed() {
        return this.duplicateEmailsAllowed;
    }

    public boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public boolean isEditUsernameAllowed() {
        return this.editUsernameAllowed;
    }

    public boolean isOrganizationsEnabled() {
        return this.organizationsEnabled;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.defaultSignatureAlgorithm;
    }

    public boolean isRevokeRefreshToken() {
        return this.revokeRefreshToken;
    }

    public int getRefreshTokenMaxReuse() {
        return this.refreshTokenMaxReuse;
    }

    public int getSsoSessionIdleTimeout() {
        return this.ssoSessionIdleTimeout;
    }

    public int getSsoSessionMaxLifespan() {
        return this.ssoSessionMaxLifespan;
    }

    public int getSsoSessionIdleTimeoutRememberMe() {
        return this.ssoSessionIdleTimeoutRememberMe;
    }

    public int getSsoSessionMaxLifespanRememberMe() {
        return this.ssoSessionMaxLifespanRememberMe;
    }

    public int getOfflineSessionIdleTimeout() {
        return this.offlineSessionIdleTimeout;
    }

    public boolean isOfflineSessionMaxLifespanEnabled() {
        return this.offlineSessionMaxLifespanEnabled;
    }

    public int getOfflineSessionMaxLifespan() {
        return this.offlineSessionMaxLifespan;
    }

    public int getClientSessionIdleTimeout() {
        return this.clientSessionIdleTimeout;
    }

    public int getClientSessionMaxLifespan() {
        return this.clientSessionMaxLifespan;
    }

    public int getClientOfflineSessionIdleTimeout() {
        return this.clientOfflineSessionIdleTimeout;
    }

    public int getClientOfflineSessionMaxLifespan() {
        return this.clientOfflineSessionMaxLifespan;
    }

    public int getAccessTokenLifespan() {
        return this.accessTokenLifespan;
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.accessTokenLifespanForImplicitFlow;
    }

    public int getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public int getAccessCodeLifespanUserAction() {
        return this.accessCodeLifespanUserAction;
    }

    public Map<String, Integer> getUserActionTokenLifespans() {
        return this.userActionTokenLifespans;
    }

    public int getAccessCodeLifespanLogin() {
        return this.accessCodeLifespanLogin;
    }

    public OAuth2DeviceConfig getOAuth2DeviceConfig(Supplier<RealmModel> modelSupplier) {
        return this.deviceConfig.get(modelSupplier);
    }

    public CibaConfig getCibaConfig(Supplier<RealmModel> modelSupplier) {
        return this.cibaConfig.get(modelSupplier);
    }

    public ParConfig getParConfig(Supplier<RealmModel> modelSupplier) {
        return this.parConfig.get(modelSupplier);
    }

    public int getActionTokenGeneratedByAdminLifespan() {
        return this.actionTokenGeneratedByAdminLifespan;
    }

    public int getActionTokenGeneratedByUserLifespan() {
        return this.actionTokenGeneratedByUserLifespan;
    }

    public int getActionTokenGeneratedByUserLifespan(String actionTokenId) {
        if (actionTokenId == null || this.userActionTokenLifespans.get(actionTokenId) == null) {
            return this.getActionTokenGeneratedByUserLifespan();
        }
        return this.userActionTokenLifespans.get(actionTokenId);
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.requiredCredentials;
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public Map<String, String> getSmtpConfig() {
        return this.smtpConfig;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.browserSecurityHeaders;
    }

    public String getLoginTheme() {
        return this.loginTheme;
    }

    public String getAccountTheme() {
        return this.accountTheme;
    }

    public String getAdminTheme() {
        return this.adminTheme;
    }

    public String getEmailTheme() {
        return this.emailTheme;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public long getEventsExpiration() {
        return this.eventsExpiration;
    }

    public Set<String> getEventsListeners() {
        return this.eventsListeners;
    }

    public Set<String> getEnabledEventTypes() {
        return this.enabledEventTypes;
    }

    public boolean isAdminEventsEnabled() {
        return this.adminEventsEnabled;
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.adminEventsDetailsEnabled;
    }

    public boolean isInternationalizationEnabled() {
        return this.internationalizationEnabled;
    }

    public Set<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public Map<String, AuthenticationFlowModel> getAuthenticationFlows() {
        return this.authenticationFlows;
    }

    public Map<String, AuthenticatorConfigModel> getAuthenticatorConfigs() {
        return this.authenticatorConfigs;
    }

    public MultivaluedHashMap<String, AuthenticationExecutionModel> getAuthenticationExecutions() {
        return this.authenticationExecutions;
    }

    public AuthenticationExecutionModel getAuthenticationExecutionByFlowId(String flowId) {
        return this.executionsByFlowId.get(flowId);
    }

    public Map<String, AuthenticationExecutionModel> getExecutionsById() {
        return this.executionsById;
    }

    public Map<String, RequiredActionProviderModel> getRequiredActionProviders() {
        return this.requiredActionProviders;
    }

    public Map<String, RequiredActionProviderModel> getRequiredActionProvidersByAlias() {
        return this.requiredActionProvidersByAlias;
    }

    public OTPPolicy getOtpPolicy() {
        return this.otpPolicy;
    }

    public WebAuthnPolicy getWebAuthnPolicy() {
        return this.webAuthnPolicy;
    }

    public WebAuthnPolicy getWebAuthnPasswordlessPolicy() {
        return this.webAuthnPasswordlessPolicy;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        return this.browserFlow;
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        return this.registrationFlow;
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        return this.directGrantFlow;
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        return this.resetCredentialsFlow;
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        return this.clientAuthenticationFlow;
    }

    public AuthenticationFlowModel getDockerAuthenticationFlow() {
        return this.dockerAuthenticationFlow;
    }

    public AuthenticationFlowModel getFirstBrokerLoginFlow() {
        return this.firstBrokerLoginFlow;
    }

    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public List<String> getDefaultDefaultClientScopes() {
        return this.defaultDefaultClientScopes;
    }

    public List<String> getOptionalDefaultClientScopes() {
        return this.optionalDefaultClientScopes;
    }

    public List<AuthenticationFlowModel> getAuthenticationFlowList() {
        return this.authenticationFlowList;
    }

    public List<RequiredActionProviderModel> getRequiredActionProviderList() {
        return this.requiredActionProviderList;
    }

    public MultivaluedMap<String, ComponentModel> getComponentsByParent() {
        return new MultivaluedHashMap(this.componentsByParent);
    }

    public MultivaluedMap<String, ComponentModel> getComponentsByParentAndType() {
        return new ConcurrentMultivaluedHashMap(this.componentsByParentAndType);
    }

    public Map<String, ComponentModel> getComponents() {
        return this.components;
    }

    public String getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        String v = this.getAttribute(name);
        return v != null && !v.isEmpty() ? Integer.valueOf(v) : defaultValue;
    }

    public Long getAttribute(String name, Long defaultValue) {
        String v = this.getAttribute(name);
        return v != null && !v.isEmpty() ? Long.valueOf(v) : defaultValue;
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        String v = this.getAttribute(name);
        return v != null && !v.isEmpty() ? Boolean.valueOf(v) : defaultValue;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isAllowUserManagedAccess() {
        return this.allowUserManagedAccess;
    }

    public Map<String, Map<String, String>> getRealmLocalizationTexts() {
        return this.realmLocalizationTexts;
    }

    public Map<String, RequiredActionConfigModel> getRequiredActionProviderConfigsByAlias() {
        return this.requiredActionProviderConfigsByAlias;
    }

    public Map<String, RequiredActionConfigModel> getRequiredActionProviderConfigs() {
        return this.requiredActionProviderConfigs;
    }
}

