/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class Mappers {
    public static Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, UserSessionEntity> userSessionEntity() {
        return new UserSessionEntityMapper();
    }

    public static Function<Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>, LoginFailureKey> loginFailureId() {
        return new LoginFailureIdMapper();
    }

    public static <T> Stream<T> toStream(Collection<T> collection) {
        return collection.stream();
    }

    public static Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, Set<String>> authClientSessionSetMapper() {
        return new AuthClientSessionSetMapper();
    }

    private static class UserSessionEntityMapper
    implements Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, UserSessionEntity>,
    Serializable {
        private UserSessionEntityMapper() {
        }

        @Override
        public UserSessionEntity apply(Map.Entry<String, SessionEntityWrapper<UserSessionEntity>> entry) {
            return entry.getValue().getEntity();
        }
    }

    private static class LoginFailureIdMapper
    implements Function<Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>, LoginFailureKey> {
        private LoginFailureIdMapper() {
        }

        @Override
        public LoginFailureKey apply(Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> entry) {
            return entry.getKey();
        }
    }

    private static class AuthClientSessionSetMapper
    implements Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, Set<String>> {
        private AuthClientSessionSetMapper() {
        }

        @Override
        public Set<String> apply(Map.Entry<String, SessionEntityWrapper<UserSessionEntity>> entry) {
            UserSessionEntity entity = entry.getValue().getEntity();
            return entity.getAuthenticatedClientSessions().keySet();
        }
    }
}

