/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.api.AsyncCache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.function.SerializableConsumer;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.AuthenticatedClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.SessionRefreshStore;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.EmbeddedClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.stream.CollectionToStreamMapper;
import org.keycloak.models.sessions.infinispan.stream.GroupAndCountCollectorSupplier;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.SessionWrapperPredicate;
import org.keycloak.models.sessions.infinispan.stream.UserSessionPredicate;
import org.keycloak.models.sessions.infinispan.util.FuturesHelper;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.utils.StreamsUtil;

public class InfinispanUserSessionProvider
implements UserSessionProvider,
SessionRefreshStore {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProvider.class);
    protected final KeycloakSession session;
    protected final InfinispanChangelogBasedTransaction<String, UserSessionEntity> sessionTx;
    protected final InfinispanChangelogBasedTransaction<String, UserSessionEntity> offlineSessionTx;
    protected final InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionTx;
    protected final InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> offlineClientSessionTx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;
    protected final PersisterLastSessionRefreshStore persisterLastSessionRefreshStore;
    protected final InfinispanKeyGenerator keyGenerator;
    protected final SessionFunction<UserSessionEntity> offlineSessionCacheEntryLifespanAdjuster;
    protected final SessionFunction<AuthenticatedClientSessionEntity> offlineClientSessionCacheEntryLifespanAdjuster;

    public InfinispanUserSessionProvider(KeycloakSession session, PersisterLastSessionRefreshStore persisterLastSessionRefreshStore, InfinispanKeyGenerator keyGenerator, InfinispanChangelogBasedTransaction<String, UserSessionEntity> sessionTx, InfinispanChangelogBasedTransaction<String, UserSessionEntity> offlineSessionTx, InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionTx, InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> offlineClientSessionTx, SessionFunction<UserSessionEntity> offlineSessionCacheEntryLifespanAdjuster, SessionFunction<AuthenticatedClientSessionEntity> offlineClientSessionCacheEntryLifespanAdjuster) {
        this.session = session;
        this.sessionTx = sessionTx;
        this.offlineSessionTx = offlineSessionTx;
        this.clientSessionTx = clientSessionTx;
        this.offlineClientSessionTx = offlineClientSessionTx;
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        this.persisterLastSessionRefreshStore = persisterLastSessionRefreshStore;
        this.keyGenerator = keyGenerator;
        this.offlineSessionCacheEntryLifespanAdjuster = offlineSessionCacheEntryLifespanAdjuster;
        this.offlineClientSessionCacheEntryLifespanAdjuster = offlineClientSessionCacheEntryLifespanAdjuster;
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
    }

    protected Cache<String, SessionEntityWrapper<UserSessionEntity>> getCache(boolean offline) {
        return offline ? this.offlineSessionTx.getCache() : this.sessionTx.getCache();
    }

    protected InfinispanChangelogBasedTransaction<String, UserSessionEntity> getTransaction(boolean offline) {
        return offline ? this.offlineSessionTx : this.sessionTx;
    }

    protected Cache<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> getClientSessionCache(boolean offline) {
        return offline ? this.offlineClientSessionTx.getCache() : this.clientSessionTx.getCache();
    }

    protected InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> getClientSessionTransaction(boolean offline) {
        return offline ? this.offlineClientSessionTx : this.clientSessionTx;
    }

    @Override
    public PersisterLastSessionRefreshStore getPersisterLastSessionRefreshStore() {
        return this.persisterLastSessionRefreshStore;
    }

    public KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.clientSessionTx;
        EmbeddedClientSessionKey key = new EmbeddedClientSessionKey(userSession.getId(), client.getId());
        AuthenticatedClientSessionEntity entity = AuthenticatedClientSessionEntity.create(realm, client, userSession);
        AuthenticatedClientSessionAdapter adapter = new AuthenticatedClientSessionAdapter(this.session, entity, client, userSession, clientSessionUpdateTx, key, false);
        UserSessionModel.SessionPersistenceState persistenceState = userSession.getPersistenceState() != null ? userSession.getPersistenceState() : UserSessionModel.SessionPersistenceState.PERSISTENT;
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        clientSessionUpdateTx.addTask(key, createClientSessionTask, entity, persistenceState);
        this.sessionTx.addTask(userSession.getId(), new RegisterClientSessionTask(key.clientId()));
        return adapter;
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, UserSessionModel.SessionPersistenceState persistenceState) {
        if (id == null) {
            id = this.keyGenerator.generateKeyString(this.session, this.sessionTx.getCache());
        }
        UserSessionEntity entity = UserSessionEntity.create(id, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        SessionUpdateTask createSessionTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(id, createSessionTask, entity, persistenceState);
        UserSessionAdapter<InfinispanUserSessionProvider> adapter = user instanceof LightweightUserAdapter ? this.wrap(realm, entity, false, user) : this.wrap(realm, entity, false);
        adapter.setPersistenceState(persistenceState);
        return adapter;
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    public void migrate(String modelVersion) {
        if ("26.0.0".equals(modelVersion)) {
            log.debug((Object)"Clear caches to migrate to Infinispan Protostream");
            CompletionStages.join(((InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class)).migrateToProtoStream());
        } else if ("26.4.0".equals(modelVersion)) {
            log.debug((Object)"Clear caches as client session entries are now outdated and are not migrated");
            AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
            Stream.of("offlineSessions", "clientSessions", "offlineClientSessions").map(s -> provider.getCache((String)s, false)).filter(Objects::nonNull).map(AsyncCache::clearAsync).forEach(arg_0 -> ((AggregateCompletionStage)stage).dependsOn(arg_0));
            CompletionStages.join((CompletionStage)stage.freeze());
        }
    }

    protected UserSessionAdapter<InfinispanUserSessionProvider> getUserSession(RealmModel realm, String id, boolean offline) {
        UserSessionEntity userSessionEntityFromCache = this.getUserSessionEntity(realm, id, offline);
        if (userSessionEntityFromCache != null) {
            return this.wrap(realm, userSessionEntityFromCache, offline);
        }
        if (!offline) {
            return null;
        }
        UserSessionEntity userSessionEntityFromPersistenceProvider = this.getUserSessionEntityFromPersistenceProvider(realm, id);
        if (userSessionEntityFromPersistenceProvider != null) {
            return this.wrap(realm, userSessionEntityFromPersistenceProvider, true);
        }
        return null;
    }

    private UserSessionEntity getUserSessionEntityFromPersistenceProvider(RealmModel realm, String sessionId) {
        log.debugf("Offline user-session not found in infinispan, attempting UserSessionPersisterProvider lookup for sessionId=%s", (Object)sessionId);
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        UserSessionModel persistentUserSession = persister.loadUserSession(realm, sessionId, true);
        if (persistentUserSession == null) {
            log.debugf("Offline user-session not found in UserSessionPersisterProvider for sessionId=%s", (Object)sessionId);
            return null;
        }
        UserSessionEntity sessionEntity = this.importUserSession(realm, persistentUserSession);
        if (sessionEntity == null) {
            persister.removeUserSession(sessionId, true);
        }
        return sessionEntity;
    }

    private UserSessionEntity getUserSessionEntityFromCacheOrImportIfNecessary(RealmModel realm, UserSessionModel persistentUserSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, persistentUserSession.getId(), true);
        if (userSessionEntity != null) {
            return userSessionEntity;
        }
        return this.importUserSession(realm, persistentUserSession);
    }

    private UserSessionEntity importUserSession(RealmModel realm, UserSessionModel persistentUserSession) {
        String sessionId = persistentUserSession.getId();
        log.debugf("Attempting to import user-session for sessionId=%s offline=true", (Object)sessionId);
        UserSessionEntity userSessionEntityToImport = UserSessionEntity.createFromModel(persistentUserSession);
        long lifespan = this.offlineSessionCacheEntryLifespanAdjuster.apply(realm, null, userSessionEntityToImport);
        long maxIdle = SessionTimeouts.getOfflineSessionMaxIdleMs(realm, null, userSessionEntityToImport);
        if (lifespan == -2L || maxIdle == -2L) {
            log.debugf("Session has expired. Do not import user-session for sessionId=%s offline=true", (Object)sessionId);
            return null;
        }
        UserSessionEntity existing = this.getTransaction(true).importSession(realm, userSessionEntityToImport.getId(), new SessionEntityWrapper<UserSessionEntity>(userSessionEntityToImport), lifespan, maxIdle);
        if (existing != null) {
            log.debugf("The user-session already imported by another transaction for sessionId=%s offline=true", (Object)sessionId);
            return existing;
        }
        log.debugf("Attempting to import the client-sessions for user-session with sessionId=%s offline=true", (Object)sessionId);
        Map<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionsById = this.computeClientSessionsToImport(persistentUserSession, userSessionEntityToImport);
        this.getClientSessionTransaction(true).importSessionsConcurrently(realm, clientSessionsById, this.offlineClientSessionCacheEntryLifespanAdjuster, SessionTimeouts::getOfflineClientSessionMaxIdleMs);
        return userSessionEntityToImport;
    }

    private Map<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> computeClientSessionsToImport(UserSessionModel persistentUserSession, UserSessionEntity userSessionToImport) {
        HashMap<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionsById = new HashMap<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>>();
        Set<String> clientSessions = userSessionToImport.getClientSessions();
        String userSessionId = userSessionToImport.getId();
        int lastSessionRefresh = userSessionToImport.getLastSessionRefresh();
        String realmId = userSessionToImport.getRealmId();
        for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
            String clientUUID = (String)entry.getKey();
            AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
            AuthenticatedClientSessionEntity clientSessionToImport = this.createAuthenticatedClientSessionInstance(clientSession, realmId, clientUUID);
            clientSessionToImport.setTimestamp(lastSessionRefresh);
            clientSessionsById.put(new EmbeddedClientSessionKey(userSessionId, clientUUID), new SessionEntityWrapper<AuthenticatedClientSessionEntity>(clientSessionToImport));
            clientSessions.add(clientUUID);
        }
        return clientSessionsById;
    }

    private UserSessionEntity getUserSessionEntity(RealmModel realm, String id, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> tx = this.getTransaction(offline);
        SessionEntityWrapper<UserSessionEntity> entityWrapper = tx.get(id);
        if (entityWrapper == null) {
            return null;
        }
        UserSessionEntity entity = entityWrapper.getEntity();
        if (!entity.getRealmId().equals(realm.getId())) {
            return null;
        }
        return entity;
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserSessionPredicate predicate, boolean offline) {
        if (offline) {
            UserModel user;
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            if (predicate.getUserId() != null && (user = this.session.users().getUserById(realm, predicate.getUserId())) != null) {
                return persister.loadUserSessionsStream(realm, user, true, Integer.valueOf(0), null);
            }
            if (predicate.getBrokerUserId() != null) {
                int split = predicate.getBrokerUserId().indexOf(46);
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("keycloak.session.realm.users.query.idp_alias", predicate.getBrokerUserId().substring(0, split));
                attributes.put("keycloak.session.realm.users.query.idp_user_id", predicate.getBrokerUserId().substring(split + 1));
                UserProvider userProvider = (UserProvider)this.session.getProvider(UserProvider.class);
                UserModel userModel = userProvider.searchForUserStream(realm, attributes, Integer.valueOf(0), null).findFirst().orElse(null);
                return userModel != null ? persister.loadUserSessionsStream(realm, userModel, true, Integer.valueOf(0), null) : Stream.empty();
            }
            throw new ModelException("For offline sessions, only lookup by userId and brokerUserId is supported");
        }
        return StreamSupport.stream(this.getCache(false).entrySet().stream().filter((Predicate)predicate).map(Mappers.userSessionEntity()).spliterator(), false).map(entity -> this.wrap(realm, (UserSessionEntity)entity, false)).filter(Objects::nonNull).map(Function.identity());
    }

    public AuthenticatedClientSessionAdapter getClientSession(UserSessionModel userSession, ClientModel client, boolean offline) {
        EmbeddedClientSessionKey key = new EmbeddedClientSessionKey(userSession.getId(), client.getId());
        AuthenticatedClientSessionEntity clientSessionEntityFromCache = this.getClientSessionEntity(key, offline);
        if (clientSessionEntityFromCache != null) {
            return this.wrap(userSession, client, clientSessionEntityFromCache, key, offline);
        }
        if (offline) {
            log.debugf("Offline client session is not found in cache, try to load from db, %s", (Object)key);
            return this.getClientSessionEntityFromPersistenceProvider(userSession, client);
        }
        return null;
    }

    private AuthenticatedClientSessionAdapter getClientSessionEntityFromPersistenceProvider(UserSessionModel userSession, ClientModel client) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        AuthenticatedClientSessionModel clientSession = persister.loadClientSession(this.session.getContext().getRealm(), client, userSession, true);
        if (clientSession == null) {
            return null;
        }
        return this.importClientSession((UserSessionAdapter)userSession, clientSession, this.getTransaction(true), this.getClientSessionTransaction(true), true);
    }

    private AuthenticatedClientSessionEntity getClientSessionEntity(EmbeddedClientSessionKey key, boolean offline) {
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> tx = this.getClientSessionTransaction(offline);
        SessionEntityWrapper<AuthenticatedClientSessionEntity> entityWrapper = tx.get(key);
        return entityWrapper == null ? null : entityWrapper.getEntity();
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserModel user) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), false);
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), false).findFirst().orElse(null);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client) {
        return this.getUserSessionsStream(realm, client, -1, -1);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        return this.getUserSessionsStream(realm, client, firstResult, maxResults, false);
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults, boolean offline) {
        if (offline) {
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            return persister.loadUserSessionsStream(realm, client, true, firstResult, maxResults).map(persistentUserSession -> this.getUserSessionEntityFromCacheOrImportIfNecessary(realm, (UserSessionModel)persistentUserSession)).filter(Objects::nonNull).map(userSessionEntity -> this.wrap(realm, (UserSessionEntity)userSessionEntity, true)).filter(Objects::nonNull);
        }
        UserSessionPredicate predicate = UserSessionPredicate.create(realm.getId()).client(client.getId());
        return StreamsUtil.paginatedStream((Stream)StreamsUtil.prepareSortedStreamToWorkInsideOfFlatMapWithTerminalOperations(this.getUserSessionsStream(realm, predicate, false).sorted(Comparator.comparing(UserSessionModel::getLastSessionRefresh))), (Integer)firstResult, (Integer)maxResults);
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionAdapter<InfinispanUserSessionProvider> userSession = this.getUserSession(realm, id, offline);
        if (userSession == null) {
            return null;
        }
        if (predicate.test(userSession)) {
            log.debugf("getUserSessionWithPredicate(%s): found in local cache", (Object)id);
            return userSession;
        }
        return null;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        if (offline) {
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            return persister.getUserSessionsCountsByClients(realm, true);
        }
        return (Map)this.getCache(false).entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId())).map(Mappers.authClientSessionSetMapper()).flatMap(CollectionToStreamMapper.getInstance()).collect(CacheCollectors.collector(GroupAndCountCollectorSupplier.getInstance()));
    }

    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        if (offline) {
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            return persister.getUserSessionsCount(realm, client, true);
        }
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).client(client.getId()), false).count();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, session, false);
        if (entity != null) {
            this.removeUserSession(entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        for (UserSessionEntity userSessionEntity : this.getCache(offline).entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).map(Mappers.userSessionEntity())) {
            this.removeUserSession(userSessionEntity, offline);
        }
    }

    public void removeAllExpired() {
        UserSessionPersisterProvider provider = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        this.session.realms().getRealmsStream().forEach(arg_0 -> ((UserSessionPersisterProvider)provider).removeExpired(arg_0));
    }

    public void removeExpired(RealmModel realm) {
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeExpired(realm);
    }

    public void removeUserSessions(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RemoveUserSessionsEvent.createEvent(RemoveUserSessionsEvent.class, "REMOVE_USER_SESSIONS_EVENT", this.session, realm.getId()));
    }

    protected void onRemoveUserSessionsEvent(String realmId) {
        this.removeLocalUserSessions(realmId, false);
        this.removeLocalUserSessions(realmId, true);
    }

    public void removeLocalUserSessions(String realmId, boolean offline) {
        FuturesHelper futures = new FuturesHelper();
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCache = CacheDecorators.localCache(this.getCache(offline));
        AdvancedCache<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCache = CacheDecorators.localCache(this.getClientSessionCache(offline));
        AtomicInteger userSessionsSize = new AtomicInteger();
        localCache.entrySet().stream().filter(SessionWrapperPredicate.create(realmId)).forEach((SerializableConsumer & Serializable)userSessionEntity -> {
            userSessionsSize.incrementAndGet();
            CompletableFuture future = localCache.removeAsync(userSessionEntity.getKey());
            futures.addTask(future);
            ((UserSessionEntity)((SessionEntityWrapper)userSessionEntity.getValue()).getEntity()).getClientSessions().forEach(clientUUID -> {
                CompletableFuture f = localClientSessionCache.removeAsync((Object)new EmbeddedClientSessionKey((String)userSessionEntity.getKey(), (String)clientUUID));
                futures.addTask(f);
            });
        });
        futures.waitForAllToFinish();
        log.debugf("Removed %d sessions in realm %s. Offline: %b", (Object)userSessionsSize.get(), (Object)realmId, (Object)offline);
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_SESSIONS", this.session, realm.getId()));
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onRealmRemoved(realm);
        }
    }

    protected void onRealmRemovedEvent(String realmId) {
        this.removeLocalUserSessions(realmId, true);
        this.removeLocalUserSessions(realmId, false);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onClientRemoved(realm, client);
        }
    }

    protected void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        UserSessionPersisterProvider persisterProvider = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (persisterProvider != null) {
            persisterProvider.onUserRemoved(realm, user);
        }
    }

    public void close() {
    }

    public int getStartupTime(RealmModel realm) {
        return ((ClusterProvider)this.session.getProvider(ClusterProvider.class)).getClusterStartupTime();
    }

    protected void removeUserSession(UserSessionEntity sessionEntity, boolean offline) {
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        sessionEntity.getClientSessions().forEach(clientUUID -> clientSessionUpdateTx.addTask(new EmbeddedClientSessionKey(sessionEntity.getId(), (String)clientUUID), Tasks.removeSync()));
        this.getTransaction(offline).addTask(sessionEntity.getId(), Tasks.removeSync());
    }

    UserSessionAdapter<InfinispanUserSessionProvider> wrap(RealmModel realm, UserSessionEntity entity, boolean offline, UserModel user) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter<InfinispanUserSessionProvider>(this.session, user, this, userSessionUpdateTx, clientSessionUpdateTx, realm, entity, offline);
    }

    UserSessionAdapter<InfinispanUserSessionProvider> wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && entity.getNotes().containsKey("keycloak.userModel")) {
            LightweightUserAdapter lua = LightweightUserAdapter.fromString((KeycloakSession)this.session, (RealmModel)realm, (String)entity.getNotes().get("keycloak.userModel"));
            UserSessionAdapter<InfinispanUserSessionProvider> us = this.wrap(realm, entity, offline, (UserModel)lua);
            lua.setUpdateHandler(lua1 -> {
                if (lua == lua1) {
                    us.setNote("keycloak.userModel", lua1.serialize());
                }
            });
            return us;
        }
        UserModel user = this.session.users().getUserById(realm, entity.getUser());
        if (user == null) {
            this.removeUserSession(entity, offline);
            if (offline) {
                ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeUserSession(entity.getId(), true);
            }
            return null;
        }
        return this.wrap(realm, entity, offline, user);
    }

    AuthenticatedClientSessionAdapter wrap(UserSessionModel userSession, ClientModel client, AuthenticatedClientSessionEntity entity, EmbeddedClientSessionKey key, boolean offline) {
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        return entity != null ? new AuthenticatedClientSessionAdapter(this.session, entity, client, userSession, clientSessionUpdateTx, key, offline) : null;
    }

    UserSessionEntity getUserSessionEntity(RealmModel realm, UserSessionModel userSession, boolean offline) {
        if (userSession instanceof UserSessionAdapter) {
            UserSessionAdapter usa = (UserSessionAdapter)userSession;
            if (!usa.getRealm().equals(realm)) {
                return null;
            }
            return usa.getEntity();
        }
        return this.getUserSessionEntity(realm, userSession.getId(), offline);
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionAdapter<InfinispanUserSessionProvider> offlineUserSession = this.importUserSession(userSession);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.getEntity().setLastSessionRefresh(currentTime);
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).createUserSession(userSession, true);
        return offlineUserSession;
    }

    public UserSessionAdapter<InfinispanUserSessionProvider> getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, userSession, true);
        if (userSessionEntity != null) {
            this.removeUserSession(userSessionEntity, true);
        }
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeUserSession(userSession.getId(), true);
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        UserSessionAdapter userSessionAdapter = offlineUserSession instanceof UserSessionAdapter ? (UserSessionAdapter)offlineUserSession : this.getOfflineUserSession(offlineUserSession.getRealm(), offlineUserSession.getId());
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(true);
        InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(true);
        AuthenticatedClientSessionAdapter offlineClientSession = this.importClientSession(userSessionAdapter, clientSession, userSessionUpdateTx, clientSessionUpdateTx, false);
        assert (offlineClientSession != null);
        offlineClientSession.setTimestamp(Time.currentTime());
        offlineClientSession.setNote("startedAt", String.valueOf(offlineClientSession.getTimestamp()));
        offlineClientSession.setNote("userSessionStartedAt", String.valueOf(offlineUserSession.getStarted()));
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).createClientSession(clientSession, true);
        return offlineClientSession;
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, UserModel user) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.loadUserSessionsStream(realm, user, true, Integer.valueOf(0), null).map(persistentUserSession -> this.getUserSessionEntityFromCacheOrImportIfNecessary(realm, (UserSessionModel)persistentUserSession)).filter(Objects::nonNull).map(userSessionEntity -> this.wrap(realm, (UserSessionEntity)userSessionEntity, true)).filter(Objects::nonNull);
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, ClientModel client, Integer first, Integer max) {
        return this.getUserSessionsStream(realm, client, first, max, true);
    }

    @Deprecated(forRemoval=true, since="25.0")
    public void importUserSessions(Collection<UserSessionModel> persistentUserSessions, boolean offline) {
        boolean importWithExpiration;
        if (persistentUserSessions == null || persistentUserSessions.isEmpty()) {
            return;
        }
        HashMap clientSessionsById = new HashMap();
        Map sessionsById = persistentUserSessions.stream().map(persistentUserSession -> {
            UserSessionEntity userSessionEntityToImport = UserSessionEntity.createFromModel(persistentUserSession);
            Set<String> clientSessions = userSessionEntityToImport.getClientSessions();
            String userSessionId = userSessionEntityToImport.getId();
            for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
                String clientUUID = (String)entry.getKey();
                AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
                AuthenticatedClientSessionEntity clientSessionToImport = this.createAuthenticatedClientSessionInstance(clientSession, userSessionEntityToImport.getRealmId(), clientUUID);
                clientSessionToImport.setTimestamp(userSessionEntityToImport.getLastSessionRefresh());
                clientSessionsById.put(new EmbeddedClientSessionKey(userSessionId, clientUUID), new SessionEntityWrapper<AuthenticatedClientSessionEntity>(clientSessionToImport));
                clientSessions.add(clientUUID);
            }
            return userSessionEntityToImport;
        }).map(SessionEntityWrapper::new).collect(Collectors.toMap(sessionEntityWrapper -> ((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        boolean bl = importWithExpiration = sessionsById.size() == 1;
        if (importWithExpiration) {
            this.importSessionsWithExpiration(sessionsById, cache, offline ? this.offlineSessionCacheEntryLifespanAdjuster : SessionTimeouts::getUserSessionLifespanMs, offline ? SessionTimeouts::getOfflineSessionMaxIdleMs : SessionTimeouts::getUserSessionMaxIdleMs);
        } else {
            Retry.executeWithBackoff(iteration -> cache.putAll(sessionsById), (int)10, (int)10);
        }
        Cache<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessCache = this.getClientSessionCache(offline);
        if (importWithExpiration) {
            this.importSessionsWithExpiration(clientSessionsById, clientSessCache, offline ? this.offlineClientSessionCacheEntryLifespanAdjuster : SessionTimeouts::getClientSessionLifespanMs, offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs);
        } else {
            Retry.executeWithBackoff(iteration -> clientSessCache.putAll(clientSessionsById), (int)10, (int)10);
        }
    }

    private <K, T extends SessionEntity> void importSessionsWithExpiration(Map<K, SessionEntityWrapper<T>> sessionsById, Cache<K, SessionEntityWrapper<T>> cache, SessionFunction<T> lifespanMsCalculator, SessionFunction<T> maxIdleTimeMsCalculator) {
        sessionsById.forEach((id, sessionEntityWrapper) -> {
            Object sessionEntity = sessionEntityWrapper.getEntity();
            RealmModel currentRealm = this.session.realms().getRealm(((SessionEntity)sessionEntity).getRealmId());
            ClientModel client = sessionEntityWrapper.getClientIfNeeded(currentRealm);
            long lifespan = lifespanMsCalculator.apply(currentRealm, client, sessionEntity);
            long maxIdle = maxIdleTimeMsCalculator.apply(currentRealm, client, sessionEntity);
            if (lifespan != -2L && maxIdle != -2L) {
                cache.put(id, sessionEntityWrapper, lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
            }
        });
    }

    protected UserSessionAdapter<InfinispanUserSessionProvider> importUserSession(UserSessionModel userSession) {
        UserSessionEntity entity = UserSessionEntity.createFromModel(userSession);
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(true);
        SessionUpdateTask importTask = Tasks.addIfAbsentSync();
        userSessionUpdateTx.addTask(userSession.getId(), importTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        return this.wrap(userSession.getRealm(), entity, true);
    }

    private AuthenticatedClientSessionAdapter importClientSession(UserSessionAdapter<?> sessionToImportInto, AuthenticatedClientSessionModel clientSession, InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx, InfinispanChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx, boolean checkExpiration) {
        AuthenticatedClientSessionEntity entity = this.createAuthenticatedClientSessionInstance(clientSession, sessionToImportInto.getRealm().getId(), clientSession.getClient().getId());
        entity.setTimestamp(sessionToImportInto.getLastSessionRefresh());
        if (checkExpiration && (SessionTimeouts.getOfflineClientSessionMaxIdleMs(sessionToImportInto.getRealm(), clientSession.getClient(), entity) == -2L || this.offlineClientSessionCacheEntryLifespanAdjuster.apply(sessionToImportInto.getRealm(), clientSession.getClient(), entity) == -2L)) {
            return null;
        }
        String clientUUID = clientSession.getClient().getId();
        String userSessionId = sessionToImportInto.getId();
        EmbeddedClientSessionKey key = new EmbeddedClientSessionKey(userSessionId, clientUUID);
        clientSessionUpdateTx.addTask(key, Tasks.addIfAbsentSync(), entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        sessionToImportInto.getEntity().getClientSessions().add(clientUUID);
        userSessionUpdateTx.addTask(sessionToImportInto.getId(), new RegisterClientSessionTask(clientUUID));
        return new AuthenticatedClientSessionAdapter(this.session, entity, clientSession.getClient(), sessionToImportInto, clientSessionUpdateTx, key, true);
    }

    private AuthenticatedClientSessionEntity createAuthenticatedClientSessionInstance(AuthenticatedClientSessionModel clientSession, String realmId, String clientId) {
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity();
        entity.setRealmId(realmId);
        entity.setClientId(clientId);
        entity.setUserSessionId(clientSession.getUserSession().getId());
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(clientSession.getNotes() == null ? new ConcurrentHashMap() : clientSession.getNotes());
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(clientSession.getTimestamp());
        return entity;
    }

    private record RegisterClientSessionTask(String clientUuid) implements SessionUpdateTask<UserSessionEntity>
    {
        @Override
        public void runUpdate(UserSessionEntity session) {
            session.getClientSessions().add(this.clientUuid);
        }

        @Override
        public SessionUpdateTask.CacheOperation getOperation() {
            return SessionUpdateTask.CacheOperation.REPLACE;
        }
    }
}

