/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class Mappers {
    public static Function<Map.Entry<String, SessionEntityWrapper>, Map.Entry<String, SessionEntity>> unwrap() {
        return new SessionUnwrap();
    }

    public static Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, String> sessionId() {
        return new SessionIdMapper();
    }

    public static Function<Map.Entry<String, SessionEntityWrapper>, SessionEntity> sessionEntity() {
        return new SessionEntityMapper();
    }

    public static Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, UserSessionEntity> userSessionEntity() {
        return new UserSessionEntityMapper();
    }

    public static Function<Map.Entry<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>>, AuthenticatedClientSessionEntity> clientSessionEntity() {
        return new AuthenticatedClientSessionEntityMapper();
    }

    public static Function<Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>, LoginFailureKey> loginFailureId() {
        return new LoginFailureIdMapper();
    }

    private static class LoginFailureIdMapper
    implements Function<Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>, LoginFailureKey>,
    Serializable {
        private LoginFailureIdMapper() {
        }

        @Override
        public LoginFailureKey apply(Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> entry) {
            return entry.getKey();
        }
    }

    private static class AuthenticatedClientSessionEntityMapper
    implements Function<Map.Entry<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>>, AuthenticatedClientSessionEntity>,
    Serializable {
        private AuthenticatedClientSessionEntityMapper() {
        }

        @Override
        public AuthenticatedClientSessionEntity apply(Map.Entry<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> entry) {
            return entry.getValue().getEntity();
        }
    }

    private static class UserSessionEntityMapper
    implements Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, UserSessionEntity>,
    Serializable {
        private UserSessionEntityMapper() {
        }

        @Override
        public UserSessionEntity apply(Map.Entry<String, SessionEntityWrapper<UserSessionEntity>> entry) {
            return entry.getValue().getEntity();
        }
    }

    private static class SessionEntityMapper
    implements Function<Map.Entry<String, SessionEntityWrapper>, SessionEntity>,
    Serializable {
        private SessionEntityMapper() {
        }

        @Override
        public SessionEntity apply(Map.Entry<String, SessionEntityWrapper> entry) {
            return entry.getValue().getEntity();
        }
    }

    private static class SessionIdMapper
    implements Function<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>, String>,
    Serializable {
        private SessionIdMapper() {
        }

        @Override
        public String apply(Map.Entry<String, SessionEntityWrapper<UserSessionEntity>> entry) {
            return entry.getKey();
        }
    }

    private static class SessionUnwrap
    implements Function<Map.Entry<String, SessionEntityWrapper>, Map.Entry<String, SessionEntity>>,
    Serializable {
        private SessionUnwrap() {
        }

        @Override
        public Map.Entry<String, SessionEntity> apply(final Map.Entry<String, SessionEntityWrapper> wrapperEntry) {
            return new Map.Entry<String, SessionEntity>(){

                @Override
                public String getKey() {
                    return (String)wrapperEntry.getKey();
                }

                @Override
                public SessionEntity getValue() {
                    return ((SessionEntityWrapper)wrapperEntry.getValue()).getEntity();
                }

                @Override
                public SessionEntity setValue(SessionEntity value) {
                    throw new IllegalStateException("Unsupported operation");
                }
            };
        }
    }
}

