/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedClientTemplate;

public class ClientTemplateAdapter
implements ClientTemplateModel {
    protected RealmCacheSession cacheSession;
    protected RealmModel cachedRealm;
    protected ClientTemplateModel updated;
    protected CachedClientTemplate cached;
    protected boolean invalidated;

    public ClientTemplateAdapter(RealmModel cachedRealm, CachedClientTemplate cached, RealmCacheSession cacheSession) {
        this.cachedRealm = cachedRealm;
        this.cacheSession = cacheSession;
        this.cached = cached;
    }

    private void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerClientTemplateInvalidation(this.cached.getId());
            this.updated = this.cacheSession.getRealmDelegate().getClientTemplateById(this.cached.getId(), this.cachedRealm);
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getRealmDelegate().getClientTemplateById(this.cached.getId(), this.cachedRealm);
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public RealmModel getRealm() {
        return this.cachedRealm;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        if (this.isUpdated()) {
            return this.updated.getProtocolMappers();
        }
        return this.cached.getProtocolMappers();
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        this.getDelegateForUpdate();
        return this.updated.addProtocolMapper(model);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.removeProtocolMapper(mapping);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.updateProtocolMapper(mapping);
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        for (ProtocolMapperModel mapping : this.cached.getProtocolMappers()) {
            if (!mapping.getId().equals(id)) continue;
            return mapping;
        }
        return null;
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        for (ProtocolMapperModel mapping : this.cached.getProtocolMappers()) {
            if (!mapping.getProtocol().equals(protocol) || !mapping.getName().equals(name)) continue;
            return mapping;
        }
        return null;
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getDescription() {
        if (this.isUpdated()) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public String getProtocol() {
        if (this.isUpdated()) {
            return this.updated.getProtocol();
        }
        return this.cached.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getDelegateForUpdate();
        this.updated.setProtocol(protocol);
    }

    public boolean isFullScopeAllowed() {
        if (this.isUpdated()) {
            return this.updated.isFullScopeAllowed();
        }
        return this.cached.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.getDelegateForUpdate();
        this.updated.setFullScopeAllowed(value);
    }

    public Set<RoleModel> getScopeMappings() {
        if (this.isUpdated()) {
            return this.updated.getScopeMappings();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cached.getScope()) {
            roles.add(this.cacheSession.getRoleById(id, this.getRealm()));
        }
        return roles;
    }

    public void addScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.addScopeMapping(role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.deleteScopeMapping(role);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.cachedRealm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isUpdated()) {
            return this.updated.hasScope(role);
        }
        if (this.cached.isFullScopeAllowed() || this.cached.getScope().contains(role.getId())) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean isPublicClient() {
        if (this.isUpdated()) {
            return this.updated.isPublicClient();
        }
        return this.cached.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getDelegateForUpdate();
        this.updated.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        if (this.isUpdated()) {
            return this.updated.isPublicClient();
        }
        return this.cached.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.getDelegateForUpdate();
        this.updated.setFrontchannelLogout(flag);
    }

    public void setAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getAttribute(String name) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name);
        }
        return this.cached.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        if (this.isUpdated()) {
            return this.updated.getAttributes();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.cached.getAttributes());
        return copy;
    }

    public boolean isBearerOnly() {
        if (this.isUpdated()) {
            return this.updated.isBearerOnly();
        }
        return this.cached.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.getDelegateForUpdate();
        this.updated.setBearerOnly(only);
    }

    public boolean isConsentRequired() {
        if (this.isUpdated()) {
            return this.updated.isConsentRequired();
        }
        return this.cached.isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.getDelegateForUpdate();
        this.updated.setConsentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        if (this.isUpdated()) {
            return this.updated.isStandardFlowEnabled();
        }
        return this.cached.isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.getDelegateForUpdate();
        this.updated.setStandardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        if (this.isUpdated()) {
            return this.updated.isImplicitFlowEnabled();
        }
        return this.cached.isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.getDelegateForUpdate();
        this.updated.setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isDirectAccessGrantsEnabled();
        }
        return this.cached.isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.getDelegateForUpdate();
        this.updated.setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isServiceAccountsEnabled();
        }
        return this.cached.isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.getDelegateForUpdate();
        this.updated.setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientModel)) {
            return false;
        }
        ClientTemplateModel that = (ClientTemplateModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

