/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshEvent;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;

public class LastSessionRefreshStore {
    protected static final Logger logger = Logger.getLogger(LastSessionRefreshStore.class);
    private final int maxIntervalBetweenMessagesSeconds;
    private final int maxCount;
    private final String eventKey;
    private volatile Map<String, SessionData> lastSessionRefreshes = new ConcurrentHashMap<String, SessionData>();
    private volatile int lastRun = Time.currentTime();

    protected LastSessionRefreshStore(int maxIntervalBetweenMessagesSeconds, int maxCount, String eventKey) {
        this.maxIntervalBetweenMessagesSeconds = maxIntervalBetweenMessagesSeconds;
        this.maxCount = maxCount;
        this.eventKey = eventKey;
    }

    public void putLastSessionRefresh(KeycloakSession kcSession, String sessionId, String realmId, int lastSessionRefresh) {
        this.lastSessionRefreshes.put(sessionId, new SessionData(realmId, lastSessionRefresh));
        this.checkSendingMessage(kcSession, lastSessionRefresh);
    }

    void checkSendingMessage(KeycloakSession kcSession, int currentTime) {
        Map<String, SessionData> refreshesToSend;
        if ((this.lastSessionRefreshes.size() >= this.maxCount || this.lastRun + this.maxIntervalBetweenMessagesSeconds <= currentTime) && (refreshesToSend = this.prepareSendingMessage(currentTime)) != null) {
            this.sendMessage(kcSession, refreshesToSend);
        }
    }

    private synchronized Map<String, SessionData> prepareSendingMessage(int currentTime) {
        if (this.lastSessionRefreshes.size() >= this.maxCount || this.lastRun + this.maxIntervalBetweenMessagesSeconds <= currentTime) {
            Map<String, SessionData> copiedRefreshesToSend = this.lastSessionRefreshes;
            this.lastSessionRefreshes = new ConcurrentHashMap<String, SessionData>();
            this.lastRun = currentTime;
            return copiedRefreshesToSend;
        }
        return null;
    }

    protected void sendMessage(KeycloakSession kcSession, Map<String, SessionData> refreshesToSend) {
        LastSessionRefreshEvent event = new LastSessionRefreshEvent(refreshesToSend);
        if (logger.isDebugEnabled()) {
            logger.debugf("Sending lastSessionRefreshes for key '%s'. Refreshes: %s", (Object)this.eventKey, (Object)event.getLastSessionRefreshes().toString());
        }
        ClusterProvider cluster = (ClusterProvider)kcSession.getProvider(ClusterProvider.class);
        cluster.notify(this.eventKey, (ClusterEvent)event, true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }
}

