/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.io.Serializable;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class RemoteCacheSessionsLoaderContext
implements SessionLoader.LoaderContext,
Serializable {
    private final int ispnSegmentsCount;
    private final int segmentsCount;
    private final int sessionsPerSegment;
    private final int sessionsTotal;

    public RemoteCacheSessionsLoaderContext(int ispnSegmentsCount, int sessionsPerSegment, int sessionsTotal) {
        this.ispnSegmentsCount = ispnSegmentsCount;
        this.sessionsPerSegment = sessionsPerSegment;
        this.sessionsTotal = sessionsTotal;
        this.segmentsCount = this.computeSegmentsCount(sessionsTotal, sessionsPerSegment, ispnSegmentsCount);
    }

    private int computeSegmentsCount(int sessionsTotal, int sessionsPerSegment, int ispnSegments) {
        int seg2;
        if (ispnSegments < 0) {
            return 1;
        }
        int seg = sessionsTotal / sessionsPerSegment;
        if (sessionsTotal % sessionsPerSegment > 0) {
            ++seg;
        }
        for (seg2 = 1; seg2 < seg && seg2 < ispnSegments; seg2 <<= 1) {
        }
        return seg2;
    }

    @Override
    public int getSegmentsCount() {
        return this.segmentsCount;
    }

    public int getIspnSegmentsCount() {
        return this.ispnSegmentsCount;
    }

    public int getSessionsPerSegment() {
        return this.sessionsPerSegment;
    }

    public int getSessionsTotal() {
        return this.sessionsTotal;
    }

    public String toString() {
        return "RemoteCacheSessionsLoaderContext [ " + "segmentsCount: " + this.segmentsCount + ", ispnSegmentsCount: " + this.ispnSegmentsCount + ", sessionsPerSegment: " + this.sessionsPerSegment + ", sessionsTotal: " + this.sessionsTotal + " ]";
    }
}

