/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;

public abstract class AbstractLastSessionRefreshStore {
    private final int maxIntervalBetweenMessagesSeconds;
    private final int maxCount;
    private volatile Map<String, SessionData> lastSessionRefreshes = new ConcurrentHashMap<String, SessionData>();
    private volatile int lastRun = Time.currentTime();

    protected AbstractLastSessionRefreshStore(int maxIntervalBetweenMessagesSeconds, int maxCount) {
        this.maxIntervalBetweenMessagesSeconds = maxIntervalBetweenMessagesSeconds;
        this.maxCount = maxCount;
    }

    public void putLastSessionRefresh(KeycloakSession kcSession, String sessionId, String realmId, int lastSessionRefresh) {
        this.lastSessionRefreshes.put(sessionId, new SessionData(realmId, lastSessionRefresh));
        this.checkSendingMessage(kcSession, lastSessionRefresh);
    }

    void checkSendingMessage(KeycloakSession kcSession, int currentTime) {
        Map<String, SessionData> refreshesToSend;
        if ((this.lastSessionRefreshes.size() >= this.maxCount || this.lastRun + this.maxIntervalBetweenMessagesSeconds <= currentTime) && (refreshesToSend = this.prepareSendingMessage(currentTime)) != null) {
            this.sendMessage(kcSession, refreshesToSend);
        }
    }

    private synchronized Map<String, SessionData> prepareSendingMessage(int currentTime) {
        if (this.lastSessionRefreshes.size() >= this.maxCount || this.lastRun + this.maxIntervalBetweenMessagesSeconds <= currentTime) {
            Map<String, SessionData> copiedRefreshesToSend = this.lastSessionRefreshes;
            this.lastSessionRefreshes = new ConcurrentHashMap<String, SessionData>();
            this.lastRun = currentTime;
            return copiedRefreshesToSend;
        }
        return null;
    }

    protected abstract void sendMessage(KeycloakSession var1, Map<String, SessionData> var2);
}

