/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionsLoaderContext;

public class RemoteCacheSessionsLoader
implements SessionLoader<RemoteCacheSessionsLoaderContext, SessionLoader.WorkerContext, SessionLoader.WorkerResult>,
Serializable {
    private static final Logger log = Logger.getLogger(RemoteCacheSessionsLoader.class);
    private final String cacheName;
    private final int sessionsPerSegment;

    public RemoteCacheSessionsLoader(String cacheName, int sessionsPerSegment) {
        this.cacheName = cacheName;
        this.sessionsPerSegment = sessionsPerSegment;
    }

    @Override
    public void init(KeycloakSession session) {
    }

    @Override
    public RemoteCacheSessionsLoaderContext computeLoaderContext(KeycloakSession session) {
        RemoteCache remoteCache = this.getRemoteCache(session);
        int sessionsTotal = remoteCache.size();
        int ispnSegments = this.getIspnSegmentsCount(remoteCache);
        return new RemoteCacheSessionsLoaderContext(ispnSegments, this.sessionsPerSegment, sessionsTotal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIspnSegmentsCount(RemoteCache remoteCache) {
        OperationsFactory operationsFactory = ((RemoteCacheImpl)remoteCache).getOperationsFactory();
        IterationStartOperation iterationStartOperation = operationsFactory.newIterationStartOperation(null, (byte[][])null, null, this.sessionsPerSegment, false, null);
        IterationStartResponse startResponse = (IterationStartResponse)Util.await((CompletableFuture)iterationStartOperation.execute());
        try {
            if (startResponse.getSegmentConsistentHash() == null) {
                int n = -1;
                return n;
            }
            int n = startResponse.getSegmentConsistentHash().getNumSegments();
            return n;
        }
        finally {
            startResponse.getChannel().close();
        }
    }

    @Override
    public SessionLoader.WorkerContext computeWorkerContext(RemoteCacheSessionsLoaderContext loaderCtx, int segment, int workerId, List<SessionLoader.WorkerResult> previousResults) {
        return new SessionLoader.WorkerContext(segment, workerId);
    }

    @Override
    public SessionLoader.WorkerResult createFailedWorkerResult(RemoteCacheSessionsLoaderContext loaderContext, SessionLoader.WorkerContext workerContext) {
        return new SessionLoader.WorkerResult(false, workerContext.getSegment(), workerContext.getWorkerId());
    }

    @Override
    public SessionLoader.WorkerResult loadSessions(KeycloakSession session, RemoteCacheSessionsLoaderContext loaderContext, SessionLoader.WorkerContext ctx) {
        Cache cache = this.getCache(session);
        AdvancedCache decoratedCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE, Flag.IGNORE_RETURN_VALUES});
        RemoteCache remoteCache = this.getRemoteCache(session);
        Set<Integer> myIspnSegments = this.getMyIspnSegments(ctx.getSegment(), loaderContext);
        log.debugf("Will do bulk load of sessions from remote cache '%s' . Segment: %d", (Object)cache.getName(), (Object)ctx.getSegment());
        HashMap remoteEntries = new HashMap();
        int countLoaded = 0;
        try (CloseableIterator iterator = null;){
            iterator = remoteCache.retrieveEntries(null, myIspnSegments, loaderContext.getSessionsPerSegment());
            while (iterator.hasNext()) {
                ++countLoaded;
                Map.Entry entry = (Map.Entry)iterator.next();
                remoteEntries.put(entry.getKey(), entry.getValue());
            }
        }
        decoratedCache.putAll(remoteEntries);
        log.debugf("Successfully finished loading sessions from cache '%s' . Segment: %d, Count of sessions loaded: %d", (Object)cache.getName(), (Object)ctx.getSegment(), (Object)countLoaded);
        return new SessionLoader.WorkerResult(true, ctx.getSegment(), ctx.getWorkerId());
    }

    protected Set<Integer> getMyIspnSegments(int segment, RemoteCacheSessionsLoaderContext ctx) {
        if (ctx.getIspnSegmentsCount() < 0) {
            return null;
        }
        if (ctx.getIspnSegmentsCount() % ctx.getSegmentsCount() > 0) {
            throw new IllegalStateException("Illegal state. IspnSegmentsCount: " + ctx.getIspnSegmentsCount() + ", segmentsCount: " + ctx.getSegmentsCount());
        }
        int countPerSegment = ctx.getIspnSegmentsCount() / ctx.getSegmentsCount();
        int first = segment * countPerSegment;
        int last = first + countPerSegment - 1;
        HashSet<Integer> myIspnSegments = new HashSet<Integer>();
        for (int i = first; i <= last; ++i) {
            myIspnSegments.add(i);
        }
        return myIspnSegments;
    }

    @Override
    public boolean isFinished(BaseCacheInitializer initializer) {
        Cache<String, Serializable> workCache = initializer.getWorkCache();
        Boolean sessionsLoaded = (Boolean)workCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}).get((Object)"PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC");
        if ((this.cacheName.equals("offlineSessions") || this.cacheName.equals("offlineClientSessions")) && sessionsLoaded != null && sessionsLoaded.booleanValue()) {
            log.debugf("Sessions already loaded in current DC. Skip sessions loading from remote cache '%s'", (Object)this.cacheName);
            return true;
        }
        log.debugf("Sessions maybe not yet loaded in current DC. Will load them from remote cache '%s'", (Object)this.cacheName);
        return false;
    }

    @Override
    public void afterAllSessionsLoaded(BaseCacheInitializer initializer) {
    }

    protected Cache getCache(KeycloakSession session) {
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        return ispn.getCache(this.cacheName);
    }

    protected RemoteCache getRemoteCache(KeycloakSession session) {
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        return ispn.getRemoteCache(this.cacheName);
    }

    public String toString() {
        return "RemoteCacheSessionsLoader [ " + "cacheName: " + this.cacheName + ", sessionsPerSegment: " + this.sessionsPerSegment + " ]";
    }
}

