/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import java.util.Objects;
import java.util.Set;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.cache.infinispan.CacheManager;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheSession;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.authorization.stream.InResourcePredicate;
import org.keycloak.models.cache.infinispan.authorization.stream.InResourceServerPredicate;
import org.keycloak.models.cache.infinispan.authorization.stream.InScopePredicate;
import org.keycloak.models.cache.infinispan.entities.Revisioned;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class StoreFactoryCacheManager
extends CacheManager {
    private static final Logger logger = Logger.getLogger(StoreFactoryCacheManager.class);

    public StoreFactoryCacheManager(Cache<String, Revisioned> cache, Cache<String, Long> revisions) {
        super(cache, revisions);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected void addInvalidationsFromEvent(InvalidationEvent event, Set<String> invalidations) {
        if (event instanceof AuthorizationCacheInvalidationEvent) {
            invalidations.add(event.getId());
            ((AuthorizationCacheInvalidationEvent)((Object)event)).addInvalidations(this, invalidations);
        }
    }

    public void resourceServerUpdated(String id, Set<String> invalidations) {
        invalidations.add(id);
        invalidations.add(StoreFactoryCacheSession.getResourceServerByClientCacheKey(id));
    }

    public void resourceServerRemoval(String id, Set<String> invalidations) {
        this.resourceServerUpdated(id, invalidations);
        this.addInvalidations(InResourceServerPredicate.create().resourceServer(id), invalidations);
    }

    public void scopeUpdated(String id, String name, String serverId, Set<String> invalidations) {
        invalidations.add(id);
        invalidations.add(StoreFactoryCacheSession.getScopeByNameCacheKey(name, serverId));
        invalidations.add(StoreFactoryCacheSession.getResourceByScopeCacheKey(id, serverId));
        invalidations.add(StoreFactoryCacheSession.getPermissionTicketByScope(id, serverId));
    }

    public void scopeRemoval(String id, String name, String serverId, Set<String> invalidations) {
        this.scopeUpdated(id, name, serverId, invalidations);
        this.addInvalidations(InScopePredicate.create().scope(id), invalidations);
    }

    public void resourceUpdated(String id, String name, String type, Set<String> uris, Set<String> scopes, String serverId, String owner, Set<String> invalidations) {
        invalidations.add(id);
        invalidations.add(StoreFactoryCacheSession.getResourceByNameCacheKey(name, owner, serverId));
        invalidations.add(StoreFactoryCacheSession.getResourceByOwnerCacheKey(owner, serverId));
        invalidations.add(StoreFactoryCacheSession.getResourceByOwnerCacheKey(owner, null));
        invalidations.add(StoreFactoryCacheSession.getPermissionTicketByResource(id, serverId));
        this.addInvalidations(InResourcePredicate.create().resource(name), invalidations);
        if (type != null) {
            invalidations.add(StoreFactoryCacheSession.getResourceByTypeCacheKey(type, serverId));
            this.addInvalidations(InResourcePredicate.create().resource(type), invalidations);
        }
        if (uris != null) {
            for (String uri : uris) {
                invalidations.add(StoreFactoryCacheSession.getResourceByUriCacheKey(uri, serverId));
            }
        }
        if (scopes != null) {
            for (String scope : scopes) {
                invalidations.add(StoreFactoryCacheSession.getResourceByScopeCacheKey(scope, serverId));
                this.addInvalidations(InScopePredicate.create().scope(scope), invalidations);
            }
        }
    }

    public void resourceRemoval(String id, String name, String type, Set<String> uris, String owner, Set<String> scopes, String serverId, Set<String> invalidations) {
        this.resourceUpdated(id, name, type, uris, scopes, serverId, owner, invalidations);
        this.addInvalidations(InResourcePredicate.create().resource(id), invalidations);
    }

    public void policyUpdated(String id, String name, Set<String> resources, Set<String> resourceTypes, Set<String> scopes, String serverId, Set<String> invalidations) {
        invalidations.add(id);
        invalidations.add(StoreFactoryCacheSession.getPolicyByNameCacheKey(name, serverId));
        if (resources != null) {
            for (String resource : resources) {
                invalidations.add(StoreFactoryCacheSession.getPolicyByResource(resource, serverId));
                if (!Objects.nonNull(scopes)) continue;
                for (String scope : scopes) {
                    invalidations.add(StoreFactoryCacheSession.getPolicyByResourceScope(scope, resource, serverId));
                }
            }
        }
        if (resourceTypes != null) {
            for (String type : resourceTypes) {
                invalidations.add(StoreFactoryCacheSession.getPolicyByResourceType(type, serverId));
            }
        }
        if (scopes != null) {
            for (String scope : scopes) {
                invalidations.add(StoreFactoryCacheSession.getPolicyByScope(scope, serverId));
                invalidations.add(StoreFactoryCacheSession.getPolicyByResourceScope(scope, null, serverId));
            }
        }
    }

    public void permissionTicketUpdated(String id, String owner, String requester, String resource, String resourceName, String scope, String serverId, Set<String> invalidations) {
        invalidations.add(id);
        invalidations.add(StoreFactoryCacheSession.getPermissionTicketByOwner(owner, serverId));
        invalidations.add(StoreFactoryCacheSession.getPermissionTicketByResource(resource, serverId));
        invalidations.add(StoreFactoryCacheSession.getPermissionTicketByGranted(requester, serverId));
        invalidations.add(StoreFactoryCacheSession.getPermissionTicketByResourceNameAndGranted(resourceName, requester, serverId));
        if (scope != null) {
            invalidations.add(StoreFactoryCacheSession.getPermissionTicketByScope(scope, serverId));
        }
    }

    public void policyRemoval(String id, String name, Set<String> resources, Set<String> resourceTypes, Set<String> scopes, String serverId, Set<String> invalidations) {
        this.policyUpdated(id, name, resources, resourceTypes, scopes, serverId, invalidations);
    }

    public void permissionTicketRemoval(String id, String owner, String requester, String resource, String resourceName, String scope, String serverId, Set<String> invalidations) {
        this.permissionTicketUpdated(id, owner, requester, resource, resourceName, scope, serverId, invalidations);
    }
}

