/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.ApplicationScopeMappingEntity;
import org.keycloak.models.jpa.entities.ApplicationUserRoleMappingEntity;
import org.keycloak.models.jpa.entities.RealmScopeMappingEntity;
import org.keycloak.models.jpa.entities.RealmUserRoleMappingEntity;
import org.keycloak.models.jpa.entities.RoleEntity;

public class ApplicationAdapter
implements ApplicationModel {
    protected EntityManager em;
    protected ApplicationEntity application;

    public ApplicationAdapter(EntityManager em, ApplicationEntity application) {
        this.em = em;
        this.application = application;
    }

    public void updateApplication() {
        this.em.flush();
    }

    public UserModel getApplicationUser() {
        return new UserAdapter(this.application.getApplicationUser());
    }

    public String getId() {
        return this.application.getId();
    }

    public String getName() {
        return this.application.getName();
    }

    public void setName(String name) {
        this.application.setName(name);
    }

    public boolean isEnabled() {
        return this.application.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.application.setEnabled(enabled);
    }

    public boolean isSurrogateAuthRequired() {
        return this.application.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.application.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.application.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.application.setManagementUrl(url);
    }

    public String getBaseUrl() {
        return this.application.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.application.setBaseUrl(url);
    }

    public RoleModel getRole(String name) {
        Collection<RoleEntity> roles = this.application.getRoles();
        if (roles == null) {
            return null;
        }
        for (RoleEntity role : roles) {
            if (!role.getName().equals(name)) continue;
            return new RoleAdapter(role);
        }
        return null;
    }

    public RoleModel addRole(String name) {
        RoleModel role = this.getRole(name);
        if (role != null) {
            return role;
        }
        RoleEntity entity = new RoleEntity();
        entity.setName(name);
        this.em.persist((Object)entity);
        this.application.getRoles().add(entity);
        this.em.flush();
        return new RoleAdapter(entity);
    }

    public boolean removeRole(String id) {
        RoleEntity role = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (role == null) {
            return false;
        }
        this.application.getRoles().remove(role);
        this.application.getDefaultRoles().remove(role);
        this.em.createQuery("delete from " + ApplicationScopeMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createQuery("delete from " + ApplicationUserRoleMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createQuery("delete from " + RealmScopeMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createQuery("delete from " + RealmUserRoleMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.remove((Object)role);
        return true;
    }

    public List<RoleModel> getRoles() {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        Collection<RoleEntity> roles = this.application.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity entity : roles) {
            list.add(new RoleAdapter(entity));
        }
        return list;
    }

    public RoleModel getRoleById(String id) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new RoleAdapter(entity);
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        TypedQuery<ApplicationUserRoleMappingEntity> query = this.getApplicationUserRoleMappingEntityTypedQuery((UserAdapter)user, (RoleAdapter)role);
        return query.getResultList().size() > 0;
    }

    protected TypedQuery<ApplicationUserRoleMappingEntity> getApplicationUserRoleMappingEntityTypedQuery(UserAdapter user, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("userHasApplicationRole", ApplicationUserRoleMappingEntity.class);
        query.setParameter("user", (Object)user.getUser());
        query.setParameter("role", (Object)role.getRole());
        query.setParameter("application", (Object)this.application);
        return query;
    }

    public void grantRole(UserModel user, RoleModel role) {
        if (this.hasRole(user, role)) {
            return;
        }
        ApplicationUserRoleMappingEntity entity = new ApplicationUserRoleMappingEntity();
        entity.setApplication(this.application);
        entity.setUser(((UserAdapter)user).getUser());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public List<RoleModel> getRoleMappings(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("userApplicationMappings", ApplicationUserRoleMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        query.setParameter("application", (Object)this.application);
        List entities = query.getResultList();
        ArrayList<RoleModel> roles = new ArrayList<RoleModel>();
        for (ApplicationUserRoleMappingEntity entity : entities) {
            roles.add(new RoleAdapter(entity.getRole()));
        }
        return roles;
    }

    public Set<String> getRoleMappingValues(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("userApplicationMappings", ApplicationUserRoleMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        query.setParameter("application", (Object)this.application);
        List entities = query.getResultList();
        HashSet<String> roles = new HashSet<String>();
        for (ApplicationUserRoleMappingEntity entity : entities) {
            roles.add(entity.getRole().getName());
        }
        return roles;
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        TypedQuery<ApplicationUserRoleMappingEntity> query = this.getApplicationUserRoleMappingEntityTypedQuery((UserAdapter)user, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (ApplicationUserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    public boolean hasRole(UserModel user, String roleName) {
        RoleModel role = this.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.hasRole(user, role);
    }

    public void addScopeMapping(UserModel agent, String roleName) {
        RoleModel role = this.getRole(roleName);
        if (role == null) {
            throw new RuntimeException("role does not exist");
        }
        this.addScopeMapping(agent, role);
    }

    public Set<String> getScopeMappingValues(UserModel agent) {
        TypedQuery query = this.em.createNamedQuery("userApplicationScopeMappings", ApplicationScopeMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)agent).getUser());
        query.setParameter("application", (Object)this.application);
        List entities = query.getResultList();
        HashSet<String> roles = new HashSet<String>();
        for (ApplicationScopeMappingEntity entity : entities) {
            roles.add(entity.getRole().getName());
        }
        return roles;
    }

    public List<RoleModel> getScopeMappings(UserModel agent) {
        TypedQuery query = this.em.createNamedQuery("userApplicationScopeMappings", ApplicationScopeMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)agent).getUser());
        query.setParameter("application", (Object)this.application);
        List entities = query.getResultList();
        ArrayList<RoleModel> roles = new ArrayList<RoleModel>();
        for (ApplicationScopeMappingEntity entity : entities) {
            roles.add(new RoleAdapter(entity.getRole()));
        }
        return roles;
    }

    public void addScopeMapping(UserModel agent, RoleModel role) {
        if (this.hasScope(agent, role)) {
            return;
        }
        ApplicationScopeMappingEntity entity = new ApplicationScopeMappingEntity();
        entity.setApplication(this.application);
        entity.setUser(((UserAdapter)agent).getUser());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void deleteScopeMapping(UserModel user, RoleModel role) {
        TypedQuery<ApplicationScopeMappingEntity> query = this.getApplicationScopeMappingQuery((UserAdapter)user, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (ApplicationScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    public boolean hasScope(UserModel user, RoleModel role) {
        TypedQuery<ApplicationScopeMappingEntity> query = this.getApplicationScopeMappingQuery((UserAdapter)user, (RoleAdapter)role);
        return query.getResultList().size() > 0;
    }

    protected TypedQuery<ApplicationScopeMappingEntity> getApplicationScopeMappingQuery(UserAdapter user, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("userHasApplicationScope", ApplicationScopeMappingEntity.class);
        query.setParameter("user", (Object)user.getUser());
        query.setParameter("role", (Object)role.getRole());
        query.setParameter("application", (Object)this.application);
        return query;
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.application.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.application.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        entities.add(((RoleAdapter)role).getRole());
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.application.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!ApplicationAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
        this.em.flush();
    }
}

