/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.ScopeMappingEntity;

public abstract class ClientAdapter
implements ClientModel {
    protected ClientEntity entity;
    protected RealmModel realm;
    protected EntityManager em;

    public ClientAdapter(RealmModel realm, ClientEntity entity, EntityManager em) {
        this.realm = realm;
        this.entity = entity;
        this.em = em;
    }

    public ClientEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getClientId() {
        return this.entity.getName();
    }

    public boolean isEnabled() {
        return this.entity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.entity.setEnabled(enabled);
    }

    public long getAllowedClaimsMask() {
        return this.entity.getAllowedClaimsMask();
    }

    public void setAllowedClaimsMask(long mask) {
        this.entity.setAllowedClaimsMask(mask);
    }

    public boolean isPublicClient() {
        return this.entity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.entity.setPublicClient(flag);
    }

    public boolean isFullScopeAllowed() {
        return this.entity.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.entity.setFullScopeAllowed(value);
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getWebOrigins());
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.entity.setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().add(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().remove(webOrigin);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getRedirectUris());
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.entity.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().add(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().remove(redirectUri);
    }

    public String getSecret() {
        return this.entity.getSecret();
    }

    public void setSecret(String secret) {
        this.entity.setSecret(secret);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.entity.getSecret());
    }

    public int getNotBefore() {
        return this.entity.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.entity.setNotBefore(notBefore);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.realm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Set<RoleModel> getScopeMappings() {
        TypedQuery query = this.em.createNamedQuery("clientScopeMappingIds", String.class);
        query.setParameter("client", (Object)this.getEntity());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    public void addScopeMapping(RoleModel role) {
        if (this.hasScope(role)) {
            return;
        }
        ScopeMappingEntity entity = new ScopeMappingEntity();
        entity.setClient(this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entity.setRole(roleEntity);
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public void deleteScopeMapping(RoleModel role) {
        TypedQuery<ScopeMappingEntity> query = this.getRealmScopeMappingQuery(role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (ScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    protected TypedQuery<ScopeMappingEntity> getRealmScopeMappingQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("hasScope", ScopeMappingEntity.class);
        query.setParameter("client", (Object)this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        query.setParameter("role", (Object)roleEntity);
        return query;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ClientAdapter that = (ClientAdapter)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.entity.getId().hashCode();
    }
}

