/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.ApplicationAdapter;
import org.keycloak.models.jpa.OAuthClientAdapter;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.OAuthClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JpaRealmProvider
implements RealmProvider {
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaRealmProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        return new RealmAdapter(this.session, this.em, realm);
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.session, this.em, realm);
    }

    public List<RealmModel> getRealms() {
        TypedQuery query = this.em.createNamedQuery("getAllRealms", RealmEntity.class);
        List entities = query.getResultList();
        ArrayList<RealmModel> realms = new ArrayList<RealmModel>();
        for (RealmEntity entity : entities) {
            realms.add(new RealmAdapter(this.session, this.em, entity));
        }
        return realms;
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmByName", RealmEntity.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        RealmEntity realm = (RealmEntity)query.getResultList().get(0);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.session, this.em, realm);
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return false;
        }
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.users().preRemove((RealmModel)adapter);
        for (ApplicationEntity a : new LinkedList<ApplicationEntity>(realm.getApplications())) {
            adapter.removeApplication(a.getId());
        }
        for (OAuthClientModel oauth : adapter.getOAuthClients()) {
            adapter.removeOAuthClient(oauth.getId());
        }
        this.em.remove((Object)realm);
        return true;
    }

    public void close() {
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!realm.getId().equals(entity.getRealmId())) {
            return null;
        }
        return new RoleAdapter(realm, this.em, entity);
    }

    public ApplicationModel getApplicationById(String id, RealmModel realm) {
        ApplicationEntity app = (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)id);
        if (app == null || !realm.getId().equals(app.getRealm().getId())) {
            return null;
        }
        return new ApplicationAdapter(realm, this.em, this.session, app);
    }

    public OAuthClientModel getOAuthClientById(String id, RealmModel realm) {
        OAuthClientEntity client = (OAuthClientEntity)this.em.find(OAuthClientEntity.class, (Object)id);
        if (client == null || !realm.getId().equals(client.getRealm().getId())) {
            return null;
        }
        return new OAuthClientAdapter(realm, client, this.em);
    }
}

