/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.jpa.session.PersistentClientSessionEntity;
import org.keycloak.models.jpa.session.PersistentUserSessionEntity;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;
import org.keycloak.models.session.PersistentClientSessionModel;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.storage.StorageId;

public class JpaUserSessionPersisterProvider
implements UserSessionPersisterProvider {
    private static final Logger logger = Logger.getLogger(JpaUserSessionPersisterProvider.class);
    private final KeycloakSession session;
    private final EntityManager em;

    public JpaUserSessionPersisterProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void createUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        PersistentUserSessionEntity entity = new PersistentUserSessionEntity();
        entity.setUserSessionId(model.getUserSessionId());
        entity.setCreatedOn(model.getStarted());
        entity.setRealmId(adapter.getRealm().getId());
        entity.setUserId(adapter.getUser().getId());
        String offlineStr = this.offlineToString(offline);
        entity.setOffline(offlineStr);
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void createClientSession(AuthenticatedClientSessionModel clientSession, boolean offline) {
        PersistentAuthenticatedClientSessionAdapter adapter = new PersistentAuthenticatedClientSessionAdapter(clientSession);
        PersistentClientSessionModel model = adapter.getUpdatedModel();
        PersistentClientSessionEntity entity = new PersistentClientSessionEntity();
        StorageId clientStorageId = new StorageId(clientSession.getClient().getId());
        if (clientStorageId.isLocal()) {
            entity.setClientId(clientStorageId.getId());
            entity.setClientStorageProvider("local");
            entity.setExternalClientId("local");
        } else {
            entity.setClientId("external");
            entity.setClientStorageProvider(clientStorageId.getProviderId());
            entity.setExternalClientId(clientStorageId.getExternalId());
        }
        entity.setTimestamp(clientSession.getTimestamp());
        String offlineStr = this.offlineToString(offline);
        entity.setOffline(offlineStr);
        entity.setUserSessionId(clientSession.getUserSession().getId());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void removeUserSession(String userSessionId, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        this.em.createNamedQuery("deleteClientSessionsByUserSession").setParameter("userSessionId", (Object)userSessionId).setParameter("offline", (Object)offlineStr).executeUpdate();
        PersistentUserSessionEntity sessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(userSessionId, offlineStr), LockModeType.PESSIMISTIC_WRITE);
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            this.em.flush();
        }
    }

    public void removeClientSession(String userSessionId, String clientUUID, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        StorageId clientStorageId = new StorageId(clientUUID);
        String clientId = "external";
        String clientStorageProvider = "local";
        String externalId = "local";
        if (clientStorageId.isLocal()) {
            clientId = clientUUID;
        } else {
            clientStorageProvider = clientStorageId.getProviderId();
            externalId = clientStorageId.getExternalId();
        }
        PersistentClientSessionEntity sessionEntity = (PersistentClientSessionEntity)this.em.find(PersistentClientSessionEntity.class, (Object)new PersistentClientSessionEntity.Key(userSessionId, clientId, clientStorageProvider, externalId, offlineStr), LockModeType.PESSIMISTIC_WRITE);
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            List<PersistentClientSessionEntity> clientSessions = this.getClientSessionsByUserSession(sessionEntity.getUserSessionId(), offline);
            if (clientSessions.size() == 0) {
                offlineStr = this.offlineToString(offline);
                PersistentUserSessionEntity userSessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(sessionEntity.getUserSessionId(), offlineStr), LockModeType.PESSIMISTIC_WRITE);
                if (userSessionEntity != null) {
                    this.em.remove((Object)userSessionEntity);
                }
            }
            this.em.flush();
        }
    }

    private List<PersistentClientSessionEntity> getClientSessionsByUserSession(String userSessionId, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = this.em.createNamedQuery("findClientSessionsByUserSession", PersistentClientSessionEntity.class);
        query.setParameter("userSessionId", (Object)userSessionId);
        query.setParameter("offline", (Object)offlineStr);
        return query.getResultList();
    }

    public void onRealmRemoved(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteClientSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(client.getId());
    }

    private void onClientRemoved(String clientUUID) {
        int num = 0;
        StorageId clientStorageId = new StorageId(clientUUID);
        num = clientStorageId.isLocal() ? this.em.createNamedQuery("deleteClientSessionsByClient").setParameter("clientId", (Object)clientUUID).executeUpdate() : this.em.createNamedQuery("deleteClientSessionsByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.onUserRemoved(realm, user.getId());
    }

    private void onUserRemoved(RealmModel realm, String userId) {
        int num = this.em.createNamedQuery("deleteClientSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
    }

    public void updateLastSessionRefreshes(RealmModel realm, int lastSessionRefresh, Collection<String> userSessionIds, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        int us = this.em.createNamedQuery("updateUserSessionLastSessionRefresh").setParameter("lastSessionRefresh", (Object)lastSessionRefresh).setParameter("realmId", (Object)realm.getId()).setParameter("offline", (Object)offlineStr).setParameter("userSessionIds", userSessionIds).executeUpdate();
        logger.debugf("Updated lastSessionRefresh of %d user sessions in realm '%s'", us, (Object)realm.getName());
    }

    public void removeExpired(RealmModel realm) {
        int expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout() - 180;
        String offlineStr = this.offlineToString(true);
        logger.tracef("Trigger removing expired user sessions for realm '%s'", (Object)realm.getName());
        int cs = this.em.createNamedQuery("deleteExpiredClientSessions").setParameter("realmId", (Object)realm.getId()).setParameter("lastSessionRefresh", (Object)expiredOffline).setParameter("offline", (Object)offlineStr).executeUpdate();
        int us = this.em.createNamedQuery("deleteExpiredUserSessions").setParameter("realmId", (Object)realm.getId()).setParameter("lastSessionRefresh", (Object)expiredOffline).setParameter("offline", (Object)offlineStr).executeUpdate();
        logger.debugf("Removed %d expired user sessions and %d expired client sessions in realm '%s'", us, cs, (Object)realm.getName());
    }

    public List<UserSessionModel> loadUserSessions(int firstResult, int maxResults, boolean offline, int lastCreatedOn, String lastUserSessionId) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = this.em.createNamedQuery("findUserSessions", PersistentUserSessionEntity.class);
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("lastCreatedOn", (Object)lastCreatedOn);
        query.setParameter("lastSessionId", (Object)lastUserSessionId);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List<UserSessionModel> result = query.getResultStream().map(this::toAdapter).collect(Collectors.toList());
        Map sessionsById = result.stream().collect(Collectors.toMap(UserSessionModel::getId, Function.identity()));
        Set<String> userSessionIds = sessionsById.keySet();
        HashSet<String> removedClientUUIDs = new HashSet<String>();
        if (!userSessionIds.isEmpty()) {
            TypedQuery query2 = this.em.createNamedQuery("findClientSessionsByUserSessions", PersistentClientSessionEntity.class);
            query2.setParameter("userSessionIds", userSessionIds);
            query2.setParameter("offline", (Object)offlineStr);
            List clientSessions = query2.getResultList();
            for (PersistentClientSessionEntity clientSession : clientSessions) {
                PersistentUserSessionAdapter userSession = (PersistentUserSessionAdapter)sessionsById.get(clientSession.getUserSessionId());
                PersistentAuthenticatedClientSessionAdapter clientSessAdapter = this.toAdapter(userSession.getRealm(), userSession, clientSession);
                Map currentClientSessions = userSession.getAuthenticatedClientSessions();
                if (clientSessAdapter.getClient() == null) {
                    removedClientUUIDs.add(clientSession.getClientId());
                    continue;
                }
                currentClientSessions.put(clientSession.getClientId(), clientSessAdapter);
            }
        }
        for (String clientUUID : removedClientUUIDs) {
            this.onClientRemoved(clientUUID);
        }
        return result;
    }

    private PersistentUserSessionAdapter toAdapter(PersistentUserSessionEntity entity) {
        RealmModel realm = this.session.realms().getRealm(entity.getRealmId());
        return this.toAdapter(realm, entity);
    }

    private PersistentUserSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionEntity entity) {
        PersistentUserSessionModel model = new PersistentUserSessionModel();
        model.setUserSessionId(entity.getUserSessionId());
        model.setStarted(entity.getCreatedOn());
        model.setLastSessionRefresh(entity.getLastSessionRefresh());
        model.setData(entity.getData());
        model.setOffline(this.offlineFromString(entity.getOffline()));
        HashMap clientSessions = new HashMap();
        return new PersistentUserSessionAdapter(this.session, model, realm, entity.getUserId(), clientSessions);
    }

    private PersistentAuthenticatedClientSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionAdapter userSession, PersistentClientSessionEntity entity) {
        String clientId = entity.getClientId();
        if (!entity.getExternalClientId().equals("local")) {
            clientId = new StorageId(entity.getClientId(), entity.getExternalClientId()).getId();
        }
        ClientModel client = realm.getClientById(clientId);
        PersistentClientSessionModel model = new PersistentClientSessionModel();
        model.setClientId(clientId);
        model.setUserSessionId(userSession.getId());
        model.setUserId(userSession.getUserId());
        model.setTimestamp(entity.getTimestamp());
        model.setData(entity.getData());
        return new PersistentAuthenticatedClientSessionAdapter(model, realm, client, (UserSessionModel)userSession);
    }

    public int getUserSessionsCount(boolean offline) {
        String offlineStr = this.offlineToString(offline);
        Query query = this.em.createNamedQuery("findUserSessionsCount");
        query.setParameter("offline", (Object)offlineStr);
        Number n = (Number)query.getSingleResult();
        return n.intValue();
    }

    public void close() {
    }

    private String offlineToString(boolean offline) {
        return offline ? "1" : "0";
    }

    private boolean offlineFromString(String offlineStr) {
        return "1".equals(offlineStr);
    }
}

