/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.store.PolicyAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.utils.StreamsUtil;

public class JPAPolicyStore
implements PolicyStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAPolicyStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Policy create(AbstractPolicyRepresentation representation, ResourceServer resourceServer) {
        PolicyEntity entity = new PolicyEntity();
        if (representation.getId() == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(representation.getId());
        }
        entity.setType(representation.getType());
        entity.setName(representation.getName());
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        PolicyAdapter model = new PolicyAdapter(entity, this.entityManager, this.provider.getStoreFactory());
        return model;
    }

    public void delete(String id) {
        PolicyEntity policy = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (policy != null) {
            this.entityManager.remove((Object)policy);
        }
    }

    public Policy findById(String id, String resourceServerId) {
        if (id == null) {
            return null;
        }
        PolicyEntity policyEntity = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id);
        if (policyEntity == null) {
            return null;
        }
        return new PolicyAdapter(policyEntity, this.entityManager, this.provider.getStoreFactory());
    }

    public Policy findByName(String name, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByName", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("name", (Object)name);
        try {
            return new PolicyAdapter((PolicyEntity)query.getSingleResult(), this.entityManager, this.provider.getStoreFactory());
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<Policy> findByResourceServer(String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByServerId", String.class);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findByResourceServer(Map<Policy.FilterOption, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(PolicyEntity.class);
        Root root = querybuilder.from(PolicyEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        querybuilder.select((Selection)root.get("id"));
        if (resourceServerId != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        }
        attributes.forEach((filterOption, value) -> {
            switch (filterOption) {
                case ID: 
                case OWNER: {
                    predicates.add(root.get(filterOption.getName()).in((Object[])value));
                    break;
                }
                case SCOPE_ID: 
                case RESOURCE_ID: {
                    String[] predicateValues = filterOption.getName().split("\\.");
                    predicates.add(root.join(predicateValues[0]).get(predicateValues[1]).in((Object[])value));
                    break;
                }
                case PERMISSION: {
                    if (Boolean.parseBoolean(value[0])) {
                        predicates.add(root.get("type").in(new Object[]{"resource", "scope", "uma"}));
                        break;
                    }
                    predicates.add(builder.not((Expression)root.get("type").in(new Object[]{"resource", "scope", "uma"})));
                    break;
                }
                case OWNER_IS_NOT_NULL: {
                    predicates.add(builder.isNotNull((Expression)root.get("owner")));
                    break;
                }
                case CONFIG: {
                    if (((String[])value).length != 2) {
                        throw new IllegalArgumentException("Config filter option requires value with two items: [config_name, expected_config_value]");
                    }
                    predicates.add(root.joinMap("config").key().in(new Object[]{value[0]}));
                    predicates.add(builder.like(root.joinMap("config").value().as(String.class), "%" + value[1] + "%"));
                    break;
                }
                case TYPE: 
                case NAME: {
                    predicates.add(builder.like(builder.lower((Expression)root.get(filterOption.getName())), "%" + value[0].toLowerCase() + "%"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported filter [" + filterOption + "]");
                }
            }
        });
        if (!attributes.containsKey(Policy.FilterOption.OWNER) && !attributes.containsKey(Policy.FilterOption.OWNER_IS_NOT_NULL)) {
            predicates.add(builder.isNull((Expression)root.get("owner")));
        }
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        List result = PaginationUtils.paginateQuery(query, firstResult, maxResult).getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public void findByResource(String resourceId, String resourceServerId, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResource", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("serverId", (Object)resourceServerId);
        PolicyStore storeFactory = this.provider.getStoreFactory().getPolicyStore();
        StreamsUtil.closing(query.getResultStream().map(entity -> storeFactory.findById(entity.getId(), resourceServerId)).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public void findByResourceType(String resourceType, String resourceServerId, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResourceType", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("type", (Object)resourceType);
        query.setParameter("serverId", (Object)resourceServerId);
        StreamsUtil.closing(query.getResultStream().map(id -> new PolicyAdapter((PolicyEntity)id, this.entityManager, this.provider.getStoreFactory())).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
        if (scopeIds == null || scopeIds.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByScope", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopeIds);
        query.setParameter("serverId", (Object)resourceServerId);
        LinkedList<Policy> list = new LinkedList<Policy>();
        PolicyStore storeFactory = this.provider.getStoreFactory().getPolicyStore();
        for (PolicyEntity entity : query.getResultList()) {
            list.add(storeFactory.findById(entity.getId(), resourceServerId));
        }
        return list;
    }

    public void findByScopeIds(List<String> scopeIds, String resourceId, String resourceServerId, Consumer<Policy> consumer) {
        TypedQuery query;
        if (resourceId == null) {
            query = this.entityManager.createNamedQuery("findPolicyIdByNullResourceScope", PolicyEntity.class);
        } else {
            query = this.entityManager.createNamedQuery("findPolicyIdByResourceScope", PolicyEntity.class);
            query.setParameter("resourceId", (Object)resourceId);
        }
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopeIds);
        query.setParameter("serverId", (Object)resourceServerId);
        StoreFactory storeFactory = this.provider.getStoreFactory();
        StreamsUtil.closing(query.getResultStream().map(id -> new PolicyAdapter((PolicyEntity)id, this.entityManager, storeFactory)).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public List<Policy> findByType(String type, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByType", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("type", (Object)type);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findDependentPolicies(String policyId, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByDependentPolices", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("policyId", (Object)policyId);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(id, resourceServerId);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }
}

