/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.io.StringWriter;
import java.io.Writer;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.DatabaseChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateIndexStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.updater.liquibase.LiquibaseJpaUpdaterProvider;

@DatabaseChange(name="createIndex", description="Creates an index on an existing column or set of columns conditionally based on the number of records.", priority=2, appliesTo={"index"})
public class CustomCreateIndexChange
extends CreateIndexChange {
    private static final Logger logger = Logger.getLogger(CustomCreateIndexChange.class);
    private int indexCreationThreshold;

    public SqlStatement[] generateStatements(Database database) {
        if (ExecutorService.getInstance().getExecutor(database) instanceof LoggingExecutor) {
            return super.generateStatements(database);
        }
        Object indexCreationThreshold = ((AbstractJdbcDatabase)database).get("keycloak.indexCreationThreshold");
        if (indexCreationThreshold instanceof Integer) {
            this.indexCreationThreshold = (Integer)indexCreationThreshold;
            if (this.indexCreationThreshold <= 0) {
                return super.generateStatements(database);
            }
        } else {
            return super.generateStatements(database);
        }
        try {
            if (!SnapshotGeneratorFactory.getInstance().has((DatabaseObject)new Table().setName(this.getTableName()).setSchema(new Schema(this.getCatalogName(), this.getSchemaName())), database)) {
                return super.generateStatements(database);
            }
            int result = ExecutorService.getInstance().getExecutor(database).queryForInt((SqlStatement)new RawSqlStatement("SELECT COUNT(*) FROM " + this.getTableNameForSqlSelects(database, this.getTableName())));
            if (result > this.indexCreationThreshold) {
                String loggingString = this.createLoggingString(database);
                logger.warnv("Following index should be created: {0}", (Object)loggingString);
                this.getChangeSet().setComments(loggingString);
                return new SqlStatement[0];
            }
        }
        catch (DatabaseException | InvalidExampleException e) {
            throw new UnexpectedLiquibaseException("Database error while index threshold validation.", e);
        }
        return super.generateStatements(database);
    }

    private String getTableNameForSqlSelects(Database database, String tableName) {
        String correctedSchemaName = database.escapeObjectName(database.getDefaultSchemaName(), Schema.class);
        return LiquibaseJpaUpdaterProvider.getTable(tableName, correctedSchemaName);
    }

    private String createLoggingString(Database database) throws DatabaseException {
        StringWriter writer = new StringWriter();
        LoggingExecutor loggingExecutor = new LoggingExecutor(ExecutorService.getInstance().getExecutor(database), (Writer)writer, database);
        CreateIndexStatement sqlStatement = new CreateIndexStatement(this.getIndexName(), this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.isUnique(), this.getAssociatedWith(), this.getColumns().toArray(new AddColumnConfig[this.getColumns().size()])).setTablespace(this.getTablespace()).setClustered(this.getClustered());
        loggingExecutor.execute((SqlStatement)sqlStatement);
        return writer.toString();
    }

    public boolean generateStatementsVolatile(Database database) {
        SqlStatement[] statements = super.generateStatements(database);
        if (statements == null) {
            return false;
        }
        for (SqlStatement statement : statements) {
            if (!SqlGeneratorFactory.getInstance().generateStatementsVolatile(statement, database)) continue;
            return true;
        }
        return false;
    }

    public Warnings warn(Database database) {
        Warnings warnings = new Warnings();
        if (this.generateStatementsVolatile(database)) {
            return warnings;
        }
        SqlStatement[] statements = super.generateStatements(database);
        if (statements == null) {
            return warnings;
        }
        for (SqlStatement statement : statements) {
            if (SqlGeneratorFactory.getInstance().supports(statement, database)) {
                warnings.addAll(SqlGeneratorFactory.getInstance().warn(statement, database));
                continue;
            }
            if (!statement.skipOnUnsupported()) continue;
            warnings.addWarning(statement.getClass().getName() + " is not supported on " + database.getShortName() + ", but " + ChangeFactory.getInstance().getChangeMetaData((Change)this).getName() + " will still execute");
        }
        return warnings;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors changeValidationErrors = new ValidationErrors();
        for (ChangeParameterMetaData param : ChangeFactory.getInstance().getChangeMetaData((Change)this).getParameters().values()) {
            if (!param.isRequiredFor(database) || param.getCurrentValue((Change)this) != null) continue;
            changeValidationErrors.addError(param.getParameterName() + " is required for " + ChangeFactory.getInstance().getChangeMetaData((Change)this).getName() + " on " + database.getShortName());
        }
        if (changeValidationErrors.hasErrors()) {
            return changeValidationErrors;
        }
        if (!this.generateStatementsVolatile(database)) {
            String unsupportedWarning = ChangeFactory.getInstance().getChangeMetaData((Change)this).getName() + " is not supported on " + database.getShortName();
            boolean sawUnsupportedError = false;
            SqlStatement[] statements = super.generateStatements(database);
            if (statements != null) {
                for (SqlStatement statement : statements) {
                    boolean supported = SqlGeneratorFactory.getInstance().supports(statement, database);
                    if (!supported && !sawUnsupportedError) {
                        if (statement.skipOnUnsupported()) continue;
                        changeValidationErrors.addError(unsupportedWarning);
                        sawUnsupportedError = true;
                        continue;
                    }
                    changeValidationErrors.addAll(SqlGeneratorFactory.getInstance().validate(statement, database));
                }
            }
        }
        return changeValidationErrors;
    }
}

