/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.UserEntity;

@NamedQueries(value={@NamedQuery(name="usersInRole", query="select u from UserRoleMappingEntity m, UserEntity u where m.roleId=:roleId and u.id=m.user"), @NamedQuery(name="userHasRole", query="select m from UserRoleMappingEntity m where m.user = :user and m.roleId = :roleId"), @NamedQuery(name="userRoleMappings", query="select m from UserRoleMappingEntity m where m.user = :user"), @NamedQuery(name="userRoleMappingIds", query="select m.roleId from UserRoleMappingEntity m where m.user = :user"), @NamedQuery(name="deleteUserRoleMappingsByRealm", query="delete from  UserRoleMappingEntity mapping where mapping.user IN (select u from UserEntity u where u.realmId=:realmId)"), @NamedQuery(name="deleteUserRoleMappingsByRealmAndLink", query="delete from  UserRoleMappingEntity mapping where mapping.user IN (select u from UserEntity u where u.realmId=:realmId and u.federationLink=:link)"), @NamedQuery(name="deleteUserRoleMappingsByRole", query="delete from UserRoleMappingEntity m where m.roleId = :roleId"), @NamedQuery(name="deleteUserRoleMappingsByUser", query="delete from UserRoleMappingEntity m where m.user = :user"), @NamedQuery(name="grantRoleToAllUsers", query="insert into UserRoleMappingEntity (roleId, user) select :roleId, user from UserEntity user where user.realmId = :realmId")})
@Table(name="USER_ROLE_MAPPING")
@Entity
@IdClass(value=Key.class)
public class UserRoleMappingEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    protected UserEntity user;
    @Id
    @Column(name="ROLE_ID")
    protected String roleId;

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserRoleMappingEntity)) {
            return false;
        }
        UserRoleMappingEntity key = (UserRoleMappingEntity)o;
        if (!this.roleId.equals(key.roleId)) {
            return false;
        }
        return this.user.equals(key.user);
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = 31 * result + this.roleId.hashCode();
        return result;
    }

    public static class Key
    implements Serializable {
        protected UserEntity user;
        protected String roleId;

        public Key() {
        }

        public Key(UserEntity user, String roleId) {
            this.user = user;
            this.roleId = roleId;
        }

        public UserEntity getUser() {
            return this.user;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.roleId.equals(key.roleId)) {
                return false;
            }
            return this.user.equals(key.user);
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = 31 * result + this.roleId.hashCode();
            return result;
        }
    }
}

