/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.jvm.ForeignKeySnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKeyConstraintType;

public class CustomForeignKeySnapshotGenerator
extends ForeignKeySnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        return super.getPriority(objectType, database) + 1;
    }

    protected ForeignKeyConstraintType convertToForeignKeyConstraintType(Integer jdbcType, Database database) throws DatabaseException {
        if (jdbcType == null) {
            return ForeignKeyConstraintType.importedKeyRestrict;
        }
        if (this.driverUsesSpFkeys(database)) {
            switch (jdbcType) {
                case 0: {
                    return ForeignKeyConstraintType.importedKeyCascade;
                }
                case 1: {
                    return ForeignKeyConstraintType.importedKeyNoAction;
                }
                case 2: {
                    return ForeignKeyConstraintType.importedKeySetNull;
                }
                case 3: {
                    return ForeignKeyConstraintType.importedKeySetDefault;
                }
            }
            throw new DatabaseException("Unknown constraint type: " + jdbcType);
        }
        switch (jdbcType) {
            case 0: {
                return ForeignKeyConstraintType.importedKeyCascade;
            }
            case 3: {
                return ForeignKeyConstraintType.importedKeyNoAction;
            }
            case 1: {
                if (database instanceof MSSQLDatabase) {
                    return ForeignKeyConstraintType.importedKeyNoAction;
                }
                return ForeignKeyConstraintType.importedKeyRestrict;
            }
            case 4: {
                return ForeignKeyConstraintType.importedKeySetDefault;
            }
            case 2: {
                return ForeignKeyConstraintType.importedKeySetNull;
            }
        }
        throw new DatabaseException("Unknown constraint type: " + jdbcType);
    }

    private boolean driverUsesSpFkeys(Database database) throws DatabaseException {
        if (!(database instanceof MSSQLDatabase)) {
            return false;
        }
        DatabaseConnection connection = database.getConnection();
        if (!(connection instanceof JdbcConnection)) {
            return false;
        }
        try {
            DatabaseMetaData metaData = ((JdbcConnection)connection).getMetaData();
            int driverMajorVersion = metaData.getDriverMajorVersion();
            int driverMinorVersion = metaData.getDriverMinorVersion();
            String driverName = metaData.getDriverName();
            if (!driverName.startsWith("Microsoft")) {
                return false;
            }
            return driverMajorVersion <= 6 && (driverMajorVersion != 6 || driverMinorVersion < 3);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

