/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.LinkedList;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserRequiredActionEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@NamedQueries(value={@NamedQuery(name="getRealmUserByUsername", query="select u from UserEntity u where u.username = :username and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByEmail", query="select u from UserEntity u where u.email = :email and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByLastName", query="select u from UserEntity u where u.lastName = :lastName and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByFirstLastName", query="select u from UserEntity u where u.firstName = :first and u.lastName = :last and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByServiceAccount", query="select u from UserEntity u where u.serviceAccountClientLink = :clientInternalId and u.realmId = :realmId"), @NamedQuery(name="getRealmUserCount", query="select count(u) from UserEntity u where u.realmId = :realmId"), @NamedQuery(name="getRealmUserCountExcludeServiceAccount", query="select count(u) from UserEntity u where u.realmId = :realmId and (u.serviceAccountClientLink is null)"), @NamedQuery(name="getRealmUsersByAttributeNameAndValue", query="select u from UserEntity u join u.attributes attr where u.realmId = :realmId and attr.name = :name and attr.value = :value"), @NamedQuery(name="getRealmUsersByAttributeNameAndLongValue", query="select u from UserEntity u join u.attributes attr where u.realmId = :realmId and attr.name = :name and attr.longValueHash = :longValueHash"), @NamedQuery(name="deleteUsersByRealm", query="delete from UserEntity u where u.realmId = :realmId"), @NamedQuery(name="deleteUsersByRealmAndLink", query="delete from UserEntity u where u.realmId = :realmId and u.federationLink=:link"), @NamedQuery(name="unlinkUsers", query="update UserEntity u set u.federationLink = null where u.realmId = :realmId and u.federationLink=:link")})
@Entity
@Table(name="USER_ENTITY", uniqueConstraints={@UniqueConstraint(columnNames={"REALM_ID", "USERNAME"}), @UniqueConstraint(columnNames={"REALM_ID", "EMAIL_CONSTRAINT"})})
public class UserEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Nationalized
    @Column(name="USERNAME")
    protected String username;
    @Nationalized
    @Column(name="FIRST_NAME")
    protected String firstName;
    @Column(name="CREATED_TIMESTAMP")
    protected Long createdTimestamp;
    @Nationalized
    @Column(name="LAST_NAME")
    protected String lastName;
    @Column(name="EMAIL")
    protected String email;
    @Column(name="ENABLED")
    protected boolean enabled;
    @Column(name="EMAIL_VERIFIED")
    protected boolean emailVerified;
    @Column(name="EMAIL_CONSTRAINT")
    protected String emailConstraint = KeycloakModelUtils.generateId();
    @Column(name="REALM_ID")
    protected String realmId;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<UserAttributeEntity> attributes = new LinkedList<UserAttributeEntity>();
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<UserRequiredActionEntity> requiredActions = new LinkedList<UserRequiredActionEntity>();
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<CredentialEntity> credentials = new LinkedList<CredentialEntity>();
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<FederatedIdentityEntity> federatedIdentities = new LinkedList<FederatedIdentityEntity>();
    @Column(name="FEDERATION_LINK")
    protected String federationLink;
    @Column(name="SERVICE_ACCOUNT_CLIENT_LINK")
    protected String serviceAccountClientLink;
    @Column(name="NOT_BEFORE")
    protected int notBefore;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.createdTimestamp = timestamp;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email, boolean allowDuplicate) {
        this.email = email;
        this.emailConstraint = email == null || allowDuplicate ? KeycloakModelUtils.generateId() : email;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getEmailConstraint() {
        return this.emailConstraint;
    }

    public void setEmailConstraint(String emailConstraint) {
        this.emailConstraint = emailConstraint;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public Collection<UserAttributeEntity> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedList<UserAttributeEntity>();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<UserAttributeEntity> attributes) {
        this.attributes = attributes;
    }

    public Collection<UserRequiredActionEntity> getRequiredActions() {
        if (this.requiredActions == null) {
            this.requiredActions = new LinkedList<UserRequiredActionEntity>();
        }
        return this.requiredActions;
    }

    public void setRequiredActions(Collection<UserRequiredActionEntity> requiredActions) {
        this.requiredActions = requiredActions;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public Collection<CredentialEntity> getCredentials() {
        if (this.credentials == null) {
            this.credentials = new LinkedList<CredentialEntity>();
        }
        return this.credentials;
    }

    public void setCredentials(Collection<CredentialEntity> credentials) {
        this.credentials = credentials;
    }

    public Collection<FederatedIdentityEntity> getFederatedIdentities() {
        if (this.federatedIdentities == null) {
            this.federatedIdentities = new LinkedList<FederatedIdentityEntity>();
        }
        return this.federatedIdentities;
    }

    public void setFederatedIdentities(Collection<FederatedIdentityEntity> federatedIdentities) {
        this.federatedIdentities = federatedIdentities;
    }

    public String getFederationLink() {
        return this.federationLink;
    }

    public void setFederationLink(String federationLink) {
        this.federationLink = federationLink;
    }

    public String getServiceAccountClientLink() {
        return this.serviceAccountClientLink;
    }

    public void setServiceAccountClientLink(String serviceAccountClientLink) {
        this.serviceAccountClientLink = serviceAccountClientLink;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserEntity)) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

