/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.jpa;

import org.keycloak.Config;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelValidationException;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.OrganizationProviderFactory;
import org.keycloak.organization.jpa.JpaOrganizationProvider;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.provider.ProviderEvent;

public class JpaOrganizationProviderFactory
implements OrganizationProviderFactory {
    public static final String ID = "jpa";

    public OrganizationProvider create(KeycloakSession session) {
        return new JpaOrganizationProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(this::handleEvents);
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    private void handleEvents(ProviderEvent e) {
        GroupModel group;
        GroupModel.GroupEvent event;
        KeycloakSession session;
        if (e instanceof GroupModel.GroupEvent && !Organizations.canManageOrganizationGroup((KeycloakSession)(session = (event = (GroupModel.GroupEvent)e).getKeycloakSession()), (GroupModel)(group = event.getGroup()))) {
            throw new ModelValidationException("Can not update organization group");
        }
    }
}

