/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.jpa.JpaUserCredentialStore;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.jpa.entities.UserConsentClientScopeEntity;
import org.keycloak.models.jpa.entities.UserConsentEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserGroupMembershipEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.jpa.JpaHashUtils;
import org.keycloak.utils.StreamsUtil;
import org.keycloak.utils.StringUtil;

public class JpaUserProvider
implements UserProvider,
UserCredentialStore {
    private static final String EMAIL = "email";
    private static final String EMAIL_VERIFIED = "emailVerified";
    private static final String USERNAME = "username";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final char ESCAPE_BACKSLASH = '\\';
    private final KeycloakSession session;
    protected EntityManager em;
    private final JpaUserCredentialStore credentialStore;

    public JpaUserProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
        this.credentialStore = new JpaUserCredentialStore(session, em);
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        UserEntity entity = new UserEntity();
        entity.setId(id);
        entity.setCreatedTimestamp(System.currentTimeMillis());
        entity.setUsername(username.toLowerCase());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(this.session, realm, this.em, entity);
        if (addDefaultRoles) {
            userModel.grantRole(realm.getDefaultRole());
            realm.getDefaultGroupsStream().forEach(userModel::joinGroupImpl);
        }
        if (addDefaultRequiredActions) {
            realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).filter(RequiredActionProviderModel::isDefaultAction).map(RequiredActionProviderModel::getAlias).forEach(userModel::addRequiredAction);
        }
        return userModel;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, KeycloakModelUtils.generateId(), username.toLowerCase(), true, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)user.getId(), LockModeType.PESSIMISTIC_WRITE);
        if (userEntity == null) {
            return false;
        }
        this.removeUser(userEntity);
        return true;
    }

    private void removeUser(UserEntity user) {
        String id = user.getId();
        this.em.createNamedQuery("deleteUserRoleMappingsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserGroupMembershipsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentClientScopesByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.remove((Object)user);
        this.em.flush();
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel identity) {
        FederatedIdentityEntity entity = new FederatedIdentityEntity();
        entity.setRealmId(realm.getId());
        entity.setIdentityProvider(identity.getIdentityProvider());
        entity.setUserId(identity.getUserId());
        entity.setUserName(identity.getUserName());
        entity.setToken(identity.getToken());
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userEntity);
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        FederatedIdentityEntity federatedIdentity = this.findFederatedIdentity(federatedUser, federatedIdentityModel.getIdentityProvider(), LockModeType.PESSIMISTIC_WRITE);
        federatedIdentity.setUserName(federatedIdentityModel.getUserName());
        federatedIdentity.setToken(federatedIdentityModel.getToken());
        this.em.persist((Object)federatedIdentity);
        this.em.flush();
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String identityProvider) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider, LockModeType.PESSIMISTIC_WRITE);
        if (entity != null) {
            this.em.remove((Object)entity);
            this.em.flush();
            return true;
        }
        return false;
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        this.em.createNamedQuery("deleteFederatedIdentityByProvider").setParameter("realmId", (Object)realm.getId()).setParameter("providerAlias", (Object)provider.getAlias()).executeUpdate();
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        long currentTime = Time.currentTimeMillis();
        UserConsentEntity consentEntity = new UserConsentEntity();
        consentEntity.setId(KeycloakModelUtils.generateId());
        consentEntity.setUser((UserEntity)this.em.getReference(UserEntity.class, (Object)userId));
        StorageId clientStorageId = new StorageId(clientId);
        if (clientStorageId.isLocal()) {
            consentEntity.setClientId(clientId);
        } else {
            consentEntity.setClientStorageProvider(clientStorageId.getProviderId());
            consentEntity.setExternalClientId(clientStorageId.getExternalId());
        }
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        this.em.persist((Object)consentEntity);
        this.em.flush();
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientId) {
        UserConsentEntity entity = this.getGrantedConsentEntity(userId, clientId, LockModeType.NONE);
        return this.toConsentModel(realm, entity);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("userConsentsByUser", UserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        return StreamsUtil.closing(query.getResultStream().map(entity -> this.toConsentModel(realm, (UserConsentEntity)entity)));
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId, LockModeType.PESSIMISTIC_WRITE);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + userId + "]");
        }
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientId) {
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId, LockModeType.PESSIMISTIC_WRITE);
        if (consentEntity == null) {
            return false;
        }
        this.em.remove((Object)consentEntity);
        this.em.flush();
        return true;
    }

    private UserConsentEntity getGrantedConsentEntity(String userId, String clientId, LockModeType lockMode) {
        StorageId clientStorageId = new StorageId(clientId);
        String queryName = clientStorageId.isLocal() ? "userConsentByUserAndClient" : "userConsentByUserAndExternalClient";
        TypedQuery query = this.em.createNamedQuery(queryName, UserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        if (clientStorageId.isLocal()) {
            query.setParameter("clientId", (Object)clientId);
        } else {
            query.setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId());
            query.setParameter("externalClientId", (Object)clientStorageId.getExternalId());
        }
        query.setLockMode(lockMode);
        List results = query.getResultList();
        if (results.size() > 1) {
            throw new ModelException("More results found for user [" + userId + "] and client [" + clientId + "]");
        }
        if (results.size() == 1) {
            return (UserConsentEntity)results.get(0);
        }
        return null;
    }

    private UserConsentModel toConsentModel(RealmModel realm, UserConsentEntity entity) {
        if (entity == null) {
            return null;
        }
        StorageId clientStorageId = entity.getClientId() == null ? new StorageId(entity.getClientStorageProvider(), entity.getExternalClientId()) : new StorageId(entity.getClientId());
        ClientModel client = realm.getClientById(clientStorageId.getId());
        if (client == null) {
            throw new ModelException("Client with id " + clientStorageId.getId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        Collection<UserConsentClientScopeEntity> grantedClientScopeEntities = entity.getGrantedClientScopes();
        if (grantedClientScopeEntities != null) {
            for (UserConsentClientScopeEntity grantedClientScope : grantedClientScopeEntities) {
                ClientScopeModel grantedClientScopeModel = KeycloakModelUtils.findClientScopeById((RealmModel)realm, (ClientModel)client, (String)grantedClientScope.getScopeId());
                if (grantedClientScopeModel == null) continue;
                model.addGrantedClientScope(grantedClientScopeModel);
            }
        }
        return model;
    }

    private void updateGrantedConsentEntity(UserConsentEntity consentEntity, UserConsentModel consentModel) {
        Collection<UserConsentClientScopeEntity> grantedClientScopeEntities = consentEntity.getGrantedClientScopes();
        HashSet<UserConsentClientScopeEntity> scopesToRemove = new HashSet<UserConsentClientScopeEntity>(grantedClientScopeEntities);
        for (ClientScopeModel clientScope : consentModel.getGrantedClientScopes()) {
            UserConsentClientScopeEntity grantedClientScopeEntity = new UserConsentClientScopeEntity();
            grantedClientScopeEntity.setUserConsent(consentEntity);
            grantedClientScopeEntity.setScopeId(clientScope.getId());
            if (!grantedClientScopeEntities.contains(grantedClientScopeEntity)) {
                this.em.persist((Object)grantedClientScopeEntity);
                this.em.flush();
                grantedClientScopeEntities.add(grantedClientScopeEntity);
                continue;
            }
            scopesToRemove.remove(grantedClientScopeEntity);
        }
        for (UserConsentClientScopeEntity toRemove : scopesToRemove) {
            grantedClientScopeEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        consentEntity.setLastUpdatedDate(Time.currentTimeMillis());
        this.em.flush();
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        UserEntity entity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        if (entity == null) {
            throw new ModelException("User does not exists");
        }
        entity.setNotBefore(notBefore);
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        UserEntity entity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        if (entity == null) {
            throw new ModelException("User does not exists");
        }
        return entity.getNotBefore();
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        if (realm.equals(role.isClientRole() ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer())) {
            this.em.createNamedQuery("grantRoleToAllUsers").setParameter("realmId", (Object)realm.getId()).setParameter("roleId", (Object)role.getId()).executeUpdate();
        }
    }

    public void preRemove(RealmModel realm) {
        this.em.createNamedQuery("deleteUserConsentClientScopesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedIdentityByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserGroupMembershipByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUsersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        this.em.createNamedQuery("deleteUserRoleMappingsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteUserRequiredActionsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteFederatedIdentityByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteCredentialsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteUserAttributesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteUserGroupMembershipsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentClientScopesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        this.em.createNamedQuery("deleteUsersByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.em.createNamedQuery("unlinkUsers").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        StorageId clientStorageId = new StorageId(client.getId());
        if (clientStorageId.isLocal()) {
            this.em.createNamedQuery("deleteUserConsentClientScopesByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
            this.em.createNamedQuery("deleteUserConsentsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        } else {
            this.em.createNamedQuery("deleteUserConsentClientScopesByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
            this.em.createNamedQuery("deleteUserConsentsByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.em.createNamedQuery("deleteUserConsentClientScopesByClientScope").setParameter("scopeId", (Object)clientScope.getId()).executeUpdate();
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        TypedQuery query = this.em.createNamedQuery("groupMembership", UserEntity.class);
        query.setParameter("groupId", (Object)group.getId());
        return StreamsUtil.closing(query.getResultStream().map(entity -> new UserAdapter(this.session, realm, this.em, (UserEntity)entity)));
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("usersInRole", UserEntity.class);
        query.setParameter("roleId", (Object)role.getId());
        return StreamsUtil.closing(query.getResultStream().map(entity -> new UserAdapter(this.session, realm, this.em, (UserEntity)entity)));
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.em.createNamedQuery("deleteUserGroupMembershipsByGroup").setParameter("groupId", (Object)group.getId()).executeUpdate();
    }

    public UserModel getUserById(RealmModel realm, String id) {
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)id);
        if (userEntity == null || !realm.getId().equals(userEntity.getRealmId())) {
            return null;
        }
        return new UserAdapter(this.session, realm, this.em, userEntity);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByUsername", UserEntity.class);
        query.setParameter(USERNAME, (Object)username.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return new UserAdapter(this.session, realm, this.em, (UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter(EMAIL, (Object)email.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        this.ensureEmailConstraint(results, realm);
        return new UserAdapter(this.session, realm, this.em, (UserEntity)results.get(0));
    }

    public void close() {
    }

    public UserModel getUserByFederatedIdentity(RealmModel realm, FederatedIdentityModel identity) {
        TypedQuery query = this.em.createNamedQuery("findUserByFederatedIdentityAndRealm", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("identityProvider", (Object)identity.getIdentityProvider());
        query.setParameter("userId", (Object)identity.getUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for identityProvider=" + identity.getIdentityProvider() + ", userId=" + identity.getUserId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(this.session, realm, this.em, user);
    }

    public UserModel getServiceAccount(ClientModel client) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByServiceAccount", UserEntity.class);
        query.setParameter("realmId", (Object)client.getRealm().getId());
        query.setParameter("clientInternalId", (Object)client.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More service account linked users found for client=" + client.getClientId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(this.session, client.getRealm(), this.em, user);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        String namedQuery = "getRealmUserCountExcludeServiceAccount";
        if (includeServiceAccount) {
            namedQuery = "getRealmUserCount";
        }
        Object count = this.em.createNamedQuery(namedQuery).setParameter("realmId", (Object)realm.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        TypedQuery query = this.em.createNamedQuery("userCountInGroups", Long.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("groupIds", groupIds);
        Long count = (Long)query.getSingleResult();
        return count.intValue();
    }

    public int getUsersCount(RealmModel realm, String search) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root root = queryBuilder.from(UserEntity.class);
        queryBuilder.select((Selection)builder.count((Expression)root));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        for (String stringToSearch : search.trim().split("\\s+")) {
            predicates.add(builder.or(this.getSearchOptionPredicateArray(stringToSearch, builder, (From<?, UserEntity>)root)));
        }
        queryBuilder.where((Predicate[])predicates.toArray(Predicate[]::new));
        return ((Long)this.em.createQuery(queryBuilder).getSingleResult()).intValue();
    }

    public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root groupMembership = queryBuilder.from(UserGroupMembershipEntity.class);
        Join userJoin = groupMembership.join("user");
        queryBuilder.select((Selection)builder.count((Expression)userJoin));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)userJoin.get("realmId"), (Object)realm.getId()));
        for (String stringToSearch : search.trim().split("\\s+")) {
            predicates.add(builder.or(this.getSearchOptionPredicateArray(stringToSearch, builder, (From<?, UserEntity>)userJoin)));
        }
        predicates.add(groupMembership.get("groupId").in(groupIds));
        queryBuilder.where((Predicate[])predicates.toArray(Predicate[]::new));
        return ((Long)this.em.createQuery(queryBuilder).getSingleResult()).intValue();
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params) {
        CriteriaBuilder qb = this.em.getCriteriaBuilder();
        CriteriaQuery userQuery = qb.createQuery(Long.class);
        Root from = userQuery.from(UserEntity.class);
        Expression count = qb.count((Expression)from);
        userQuery = userQuery.select((Selection)count);
        List<Predicate> restrictions = this.predicates(params, (Root<UserEntity>)from, Map.of());
        restrictions.add(qb.equal((Expression)from.get("realmId"), (Object)realm.getId()));
        userQuery = userQuery.where((Predicate[])restrictions.toArray(Predicate[]::new));
        TypedQuery query = this.em.createQuery(userQuery);
        Long result = (Long)query.getSingleResult();
        return result.intValue();
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(UserEntity.class);
        countQuery.select((Selection)cb.count((Expression)root));
        List<Predicate> restrictions = this.predicates(params, (Root<UserEntity>)root, Map.of());
        restrictions.add(cb.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        this.groupsWithPermissionsSubquery(countQuery, groupIds, (Root<UserEntity>)root, restrictions);
        countQuery.where((Predicate[])restrictions.toArray(Predicate[]::new));
        TypedQuery query = this.em.createQuery(countQuery);
        Long result = (Long)query.getSingleResult();
        return result.intValue();
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("groupMembership", UserEntity.class);
        query.setParameter("groupId", (Object)group.getId());
        return StreamsUtil.closing(PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream().map(user -> new UserAdapter(this.session, realm, this.em, (UserEntity)user)));
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, String search, Boolean exact, Integer first, Integer max) {
        TypedQuery query;
        if (StringUtil.isBlank((String)search)) {
            query = this.em.createNamedQuery("groupMembership", UserEntity.class);
        } else if (Boolean.TRUE.equals(exact)) {
            query = this.em.createNamedQuery("groupMembershipByUser", UserEntity.class);
            query.setParameter("search", (Object)search);
        } else {
            query = this.em.createNamedQuery("groupMembershipByUserContained", UserEntity.class);
            query.setParameter("search", (Object)search.toLowerCase());
        }
        query.setParameter("groupId", (Object)group.getId());
        return StreamsUtil.closing(PaginationUtils.paginateQuery(query, first, max).getResultStream().map(user -> new UserAdapter(this.session, realm, this.em, (UserEntity)user)));
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("usersInRole", UserEntity.class);
        query.setParameter("roleId", (Object)role.getId());
        UserProvider users = this.session.users();
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream()).map(userEntity -> users.getUserById(realm, userEntity.getId())).filter(Objects::nonNull);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        attributes.put("keycloak.session.realm.users.query.search", search);
        attributes.put("keycloak.session.realm.users.query.include_service_account", Boolean.FALSE.toString());
        return this.searchForUserStream(realm, attributes, firstResult, maxResults);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(UserEntity.class);
        Root root = queryBuilder.from(UserEntity.class);
        HashMap<String, String> customLongValueSearchAttributes = new HashMap<String, String>();
        List<Predicate> predicates = this.predicates(attributes, (Root<UserEntity>)root, customLongValueSearchAttributes);
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        Set userGroups = (Set)this.session.getAttribute("keycloak.session.realm.users.query.groups");
        if (userGroups != null) {
            this.groupsWithPermissionsSubquery(queryBuilder, userGroups, (Root<UserEntity>)root, predicates);
        }
        queryBuilder.where((Predicate[])predicates.toArray(Predicate[]::new)).orderBy(new Order[]{builder.asc((Expression)root.get(USERNAME))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        UserProvider users = this.session.users();
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultStream()).filter(JpaHashUtils.predicateForFilteringUsersByAttributes(customLongValueSearchAttributes, JpaHashUtils::compareSourceValueLowerCase)).map(userEntity -> users.getUserById(realm, userEntity.getId())).filter(Objects::nonNull);
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        boolean longAttribute = attrValue != null && attrValue.length() > 255;
        TypedQuery query = longAttribute ? this.em.createNamedQuery("getRealmUsersByAttributeNameAndLongValue", UserEntity.class).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)attrName).setParameter("longValueHash", (Object)JpaHashUtils.hashForAttributeValue(attrValue)) : this.em.createNamedQuery("getRealmUsersByAttributeNameAndValue", UserEntity.class).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)attrName).setParameter("value", (Object)attrValue);
        return StreamsUtil.closing(query.getResultStream().filter(longAttribute ? JpaHashUtils.predicateForFilteringUsersByAttributes(Map.of(attrName, attrValue), JpaHashUtils::compareSourceValue) : u -> true).map(userEntity -> new UserAdapter(this.session, realm, this.em, (UserEntity)userEntity)));
    }

    private FederatedIdentityEntity findFederatedIdentity(UserModel user, String identityProvider, LockModeType lockMode) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUserAndProvider", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        query.setParameter("identityProvider", (Object)identityProvider);
        query.setLockMode(lockMode);
        List results = query.getResultList();
        return !results.isEmpty() ? (FederatedIdentityEntity)results.get(0) : null;
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUser", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        return StreamsUtil.closing(query.getResultStream().map(entity -> new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken())).distinct());
    }

    public FederatedIdentityModel getFederatedIdentity(RealmModel realm, UserModel user, String identityProvider) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider, LockModeType.NONE);
        return entity != null ? new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken()) : null;
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (component.getProviderType().equals(UserStorageProvider.class.getName())) {
            this.removeImportedUsers(realm, component.getId());
        }
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.removeConsentByClientStorageProvider(realm, component.getId());
        }
    }

    protected void removeConsentByClientStorageProvider(RealmModel realm, String providerId) {
        this.em.createNamedQuery("deleteUserConsentClientScopesByClientStorageProvider").setParameter("clientStorageProvider", (Object)providerId).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByClientStorageProvider").setParameter("clientStorageProvider", (Object)providerId).executeUpdate();
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.credentialStore.updateCredential(realm, user, cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = this.credentialStore.createCredentialEntity(realm, user, cred);
        UserEntity userEntity = this.userInEntityManagerContext(user.getId());
        if (userEntity != null) {
            userEntity.getCredentials().add(entity);
        }
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = this.credentialStore.removeCredentialEntity(realm, user, id);
        UserEntity userEntity = this.userInEntityManagerContext(user.getId());
        if (entity != null && userEntity != null) {
            userEntity.getCredentials().remove(entity);
        }
        return entity != null;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.credentialStore.getStoredCredentialById(realm, user, id);
    }

    protected CredentialModel toModel(CredentialEntity entity) {
        return this.credentialStore.toModel(entity);
    }

    public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, UserModel user) {
        return this.credentialStore.getStoredCredentialsStream(realm, user);
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, UserModel user, String type) {
        UserEntity userEntity = this.userInEntityManagerContext(user.getId());
        if (userEntity != null) {
            return userEntity.getCredentials().stream().filter(it -> type.equals(it.getType())).sorted(Comparator.comparingInt(CredentialEntity::getPriority)).map(this::toModel);
        }
        return this.credentialStore.getStoredCredentialsByTypeStream(realm, user, type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.credentialStore.getStoredCredentialByNameAndType(realm, user, name, type);
    }

    public boolean moveCredentialTo(RealmModel realm, UserModel user, String id, String newPreviousCredentialId) {
        return this.credentialStore.moveCredentialTo(realm, user, id, newPreviousCredentialId);
    }

    protected void ensureEmailConstraint(List<UserEntity> users, RealmModel realm) {
        UserEntity user = users.get(0);
        if (users.size() > 1) {
            throw new ModelDuplicateException("Multiple users with email '" + user.getEmail() + "' exist in Keycloak.");
        }
        if (realm.isDuplicateEmailsAllowed()) {
            return;
        }
        if (user.getEmail() != null && !user.getEmail().equals(user.getEmailConstraint())) {
            user.setEmailConstraint(user.getEmail());
            this.em.persist((Object)user);
        }
    }

    private Predicate[] getSearchOptionPredicateArray(String value, CriteriaBuilder builder, From<?, UserEntity> from) {
        value = ((String)value).toLowerCase();
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
        if (((String)value).length() >= 2 && ((String)value).charAt(0) == '\"' && ((String)value).charAt(((String)value).length() - 1) == '\"') {
            value = ((String)value).substring(1, ((String)value).length() - 1);
            orPredicates.add(builder.equal((Expression)from.get(USERNAME), value));
            orPredicates.add(builder.equal((Expression)from.get(EMAIL), value));
            orPredicates.add(builder.equal(builder.lower((Expression)from.get(FIRST_NAME)), value));
            orPredicates.add(builder.equal(builder.lower((Expression)from.get(LAST_NAME)), value));
        } else {
            value = ((String)value).replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
            if (((String)(value = ((String)value).replace("*", "%"))).isEmpty() || ((String)value).charAt(((String)value).length() - 1) != '%') {
                value = (String)value + "%";
            }
            orPredicates.add(builder.like((Expression)from.get(USERNAME), (String)value, '\\'));
            orPredicates.add(builder.like((Expression)from.get(EMAIL), (String)value, '\\'));
            orPredicates.add(builder.like(builder.lower((Expression)from.get(FIRST_NAME)), (String)value, '\\'));
            orPredicates.add(builder.like(builder.lower((Expression)from.get(LAST_NAME)), (String)value, '\\'));
        }
        return (Predicate[])orPredicates.toArray(Predicate[]::new);
    }

    private UserEntity userInEntityManagerContext(String id) {
        UserEntity user = (UserEntity)this.em.getReference(UserEntity.class, (Object)id);
        return this.em.contains((Object)user) ? user : null;
    }

    private List<Predicate> predicates(Map<String, String> attributes, Root<UserEntity> root, Map<String, String> customLongValueSearchAttributes) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
        Join federatedIdentitiesJoin = null;
        block24: for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            switch (key) {
                case "keycloak.session.realm.users.query.search": {
                    for (String stringToSearch : value.trim().split("\\s+")) {
                        predicates.add(builder.or(this.getSearchOptionPredicateArray(stringToSearch, builder, (From<?, UserEntity>)root)));
                    }
                    continue block24;
                }
                case "firstName": 
                case "lastName": {
                    if (Boolean.parseBoolean(attributes.get("keycloak.session.realm.users.query.exact"))) {
                        predicates.add(builder.equal(builder.lower((Expression)root.get(key)), (Object)value.toLowerCase()));
                        break;
                    }
                    predicates.add(builder.like(builder.lower((Expression)root.get(key)), "%" + value.toLowerCase() + "%"));
                    break;
                }
                case "username": 
                case "email": {
                    if (Boolean.parseBoolean(attributes.get("keycloak.session.realm.users.query.exact"))) {
                        predicates.add(builder.equal((Expression)root.get(key), (Object)value.toLowerCase()));
                        break;
                    }
                    predicates.add(builder.like((Expression)root.get(key), "%" + value.toLowerCase() + "%"));
                    break;
                }
                case "emailVerified": {
                    predicates.add(builder.equal((Expression)root.get(key), (Object)Boolean.valueOf(value.toLowerCase())));
                    break;
                }
                case "enabled": {
                    predicates.add(builder.equal((Expression)root.get(key), (Object)Boolean.valueOf(value)));
                    break;
                }
                case "keycloak.session.realm.users.query.idp_alias": {
                    if (federatedIdentitiesJoin == null) {
                        federatedIdentitiesJoin = root.join("federatedIdentities");
                    }
                    predicates.add(builder.equal((Expression)federatedIdentitiesJoin.get("identityProvider"), (Object)value));
                    break;
                }
                case "keycloak.session.realm.users.query.idp_user_id": {
                    if (federatedIdentitiesJoin == null) {
                        federatedIdentitiesJoin = root.join("federatedIdentities");
                    }
                    predicates.add(builder.equal((Expression)federatedIdentitiesJoin.get("userId"), (Object)value));
                    break;
                }
                case "keycloak.session.realm.users.query.exact": {
                    break;
                }
                default: {
                    Join attributesJoin = root.join("attributes", JoinType.LEFT);
                    if (value.length() > 255) {
                        customLongValueSearchAttributes.put(key, value);
                        attributePredicates.add(builder.and((Expression)builder.equal((Expression)attributesJoin.get("name"), (Object)key), (Expression)builder.equal((Expression)attributesJoin.get("longValueHashLowerCase"), (Object)JpaHashUtils.hashForAttributeValueLowerCase(value))));
                        break;
                    }
                    if (Boolean.parseBoolean(attributes.get("keycloak.session.realm.users.query.exact"))) {
                        attributePredicates.add(builder.and((Expression)builder.equal((Expression)attributesJoin.get("name"), (Object)key), (Expression)builder.equal(builder.lower((Expression)attributesJoin.get("value")), (Object)value.toLowerCase())));
                        break;
                    }
                    attributePredicates.add(builder.and((Expression)builder.equal((Expression)attributesJoin.get("name"), (Object)key), (Expression)builder.like(builder.lower((Expression)attributesJoin.get("value")), "%" + value.toLowerCase() + "%")));
                    break;
                }
                case "keycloak.session.realm.users.query.include_service_account": {
                    if (attributes.containsKey("keycloak.session.realm.users.query.include_service_account") && Boolean.parseBoolean(attributes.get("keycloak.session.realm.users.query.include_service_account"))) continue block24;
                    predicates.add(root.get("serviceAccountClientLink").isNull());
                }
            }
        }
        if (!attributePredicates.isEmpty()) {
            predicates.add(builder.and((Predicate[])attributePredicates.toArray(Predicate[]::new)));
        }
        return predicates;
    }

    private void groupsWithPermissionsSubquery(CriteriaQuery<?> query, Set<String> groupIds, Root<UserEntity> root, List<Predicate> restrictions) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        Subquery subquery = query.subquery(String.class);
        Root from = subquery.from(UserGroupMembershipEntity.class);
        subquery.select(cb.literal((Object)1));
        ArrayList<Predicate> subPredicates = new ArrayList<Predicate>();
        subPredicates.add(from.get("groupId").in(groupIds));
        subPredicates.add(cb.equal((Expression)from.get("user").get("id"), (Expression)root.get("id")));
        Subquery subquery1 = query.subquery(String.class);
        subquery1.select(cb.literal((Object)1));
        Root from1 = subquery1.from(ResourceEntity.class);
        ArrayList<Predicate> subs = new ArrayList<Predicate>();
        Path groupId = from.get("groupId");
        subs.add(cb.like((Expression)from1.get("name"), cb.concat("group.resource.", (Expression)groupId)));
        subquery1.where((Predicate[])subs.toArray(Predicate[]::new));
        subPredicates.add(cb.exists(subquery1));
        subquery.where((Predicate[])subPredicates.toArray(Predicate[]::new));
        restrictions.add(cb.exists(subquery));
    }
}

