/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.CustomChangeException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdateAuthz_3_4_0_CR1
extends CustomKeycloakTask {
    private SqlStatement generateUpdateStatement(String resourceServerDetailTable) {
        String resourceServerTableName = this.database.correctObjectName(this.getTableName("RESOURCE_SERVER"), Table.class);
        String resourceServerDetailTableName = this.database.correctObjectName(this.getTableName(resourceServerDetailTable), Table.class);
        if (this.database instanceof MSSQLDatabase) {
            return new RawSqlStatement("UPDATE " + resourceServerDetailTableName + " SET RESOURCE_SERVER_CLIENT_ID = s.CLIENT_ID FROM  (SELECT ID, CLIENT_ID FROM " + resourceServerTableName + ") s  WHERE s.ID = " + resourceServerDetailTableName + ".RESOURCE_SERVER_ID");
        }
        return new RawSqlStatement("UPDATE " + resourceServerDetailTableName + " p SET RESOURCE_SERVER_CLIENT_ID = (SELECT CLIENT_ID FROM " + resourceServerTableName + " s WHERE s.ID = p.RESOURCE_SERVER_ID)");
    }

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.statements.add(this.generateUpdateStatement("RESOURCE_SERVER_POLICY"));
        this.statements.add(this.generateUpdateStatement("RESOURCE_SERVER_RESOURCE"));
        this.statements.add(this.generateUpdateStatement("RESOURCE_SERVER_SCOPE"));
    }

    @Override
    protected String getTaskId() {
        return "Update authz-3.4.0.CR1-resource-server-pk-change-part2";
    }
}

