/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.jpa;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.jpa.AdminEventEntity;
import org.keycloak.events.jpa.EventEntity;
import org.keycloak.events.jpa.JpaAdminEventQuery;
import org.keycloak.events.jpa.JpaEventQuery;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.RealmAttributeEntity;
import org.keycloak.models.jpa.entities.RealmEntity;

public class JpaEventStoreProvider
implements EventStoreProvider {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, String>> mapType = new TypeReference<Map<String, String>>(){};
    private static final Logger logger = Logger.getLogger(JpaEventStoreProvider.class);
    private final KeycloakSession session;
    private final EntityManager em;

    public JpaEventStoreProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public EventQuery createQuery() {
        return new JpaEventQuery(this.em);
    }

    public void clear() {
        this.em.createQuery("delete from EventEntity").executeUpdate();
    }

    public void clear(RealmModel realm) {
        this.em.createQuery("delete from EventEntity where realmId = :realmId").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void clear(RealmModel realm, long olderThan) {
        this.em.createQuery("delete from EventEntity where realmId = :realmId and time < :time").setParameter("realmId", (Object)realm.getId()).setParameter("time", (Object)olderThan).executeUpdate();
    }

    public void clearExpiredEvents() {
        int numDeleted = 0;
        long currentTimeMillis = Time.currentTimeMillis();
        List eventExpirations = this.em.createQuery("select distinct realm.eventsExpiration from RealmEntity realm where realm.eventsExpiration > 0").getResultList();
        for (Long expiration : eventExpirations) {
            List realmIds = this.em.createQuery("select realm.id from RealmEntity realm where realm.eventsExpiration = :expiration").setParameter("expiration", (Object)expiration).getResultList();
            int currentNumDeleted = this.em.createQuery("delete from EventEntity where realmId in :realmIds and time < :eventTime").setParameter("realmIds", (Object)realmIds).setParameter("eventTime", (Object)(currentTimeMillis - expiration * 1000L)).executeUpdate();
            logger.tracef("Deleted %d events for the expiration %d", currentNumDeleted, (Object)expiration);
            numDeleted += currentNumDeleted;
        }
        logger.debugf("Cleared %d expired events in all realms", numDeleted);
    }

    public void onEvent(Event event) {
        this.em.persist((Object)this.convertEvent(event));
    }

    public AdminEventQuery createAdminQuery() {
        return new JpaAdminEventQuery(this.em);
    }

    public void clearAdmin() {
        this.em.createQuery("delete from AdminEventEntity").executeUpdate();
    }

    public void clearAdmin(RealmModel realm) {
        this.em.createQuery("delete from AdminEventEntity where realmId = :realmId").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void clearAdmin(RealmModel realm, long olderThan) {
        this.em.createQuery("delete from AdminEventEntity where realmId = :realmId and time < :time").setParameter("realmId", (Object)realm.getId()).setParameter("time", (Object)olderThan).executeUpdate();
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        this.em.persist((Object)this.convertAdminEvent(event, includeRepresentation));
    }

    public void close() {
    }

    private EventEntity convertEvent(Event event) {
        EventEntity eventEntity = new EventEntity();
        eventEntity.setId(event.getId() == null ? UUID.randomUUID().toString() : event.getId());
        eventEntity.setTime(event.getTime());
        eventEntity.setType(event.getType().toString());
        eventEntity.setRealmId(event.getRealmId());
        eventEntity.setClientId(event.getClientId());
        eventEntity.setUserId(event.getUserId());
        eventEntity.setSessionId(event.getSessionId());
        eventEntity.setIpAddress(event.getIpAddress());
        eventEntity.setError(event.getError());
        JpaEventStoreProvider.setDetails(eventEntity::setDetailsJson, event.getDetails());
        return eventEntity;
    }

    static Event convertEvent(EventEntity eventEntity) {
        Event event = new Event();
        event.setId(eventEntity.getId() == null ? UUID.randomUUID().toString() : eventEntity.getId());
        event.setTime(eventEntity.getTime());
        event.setType(EventType.valueOf((String)eventEntity.getType()));
        event.setRealmId(eventEntity.getRealmId());
        event.setClientId(eventEntity.getClientId());
        event.setUserId(eventEntity.getUserId());
        event.setSessionId(eventEntity.getSessionId());
        event.setIpAddress(eventEntity.getIpAddress());
        event.setError(eventEntity.getError());
        JpaEventStoreProvider.setDetails(arg_0 -> ((Event)event).setDetails(arg_0), eventEntity.getDetailsJson());
        return event;
    }

    private AdminEventEntity convertAdminEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        AdminEventEntity adminEventEntity = new AdminEventEntity();
        adminEventEntity.setId(adminEvent.getId() == null ? UUID.randomUUID().toString() : adminEvent.getId());
        adminEventEntity.setTime(adminEvent.getTime());
        adminEventEntity.setRealmId(adminEvent.getRealmId());
        JpaEventStoreProvider.setAuthDetails(adminEventEntity, adminEvent.getAuthDetails());
        adminEventEntity.setOperationType(adminEvent.getOperationType().toString());
        if (adminEvent.getResourceTypeAsString() != null) {
            adminEventEntity.setResourceType(adminEvent.getResourceTypeAsString());
        }
        adminEventEntity.setResourcePath(adminEvent.getResourcePath());
        adminEventEntity.setError(adminEvent.getError());
        if (includeRepresentation) {
            adminEventEntity.setRepresentation(adminEvent.getRepresentation());
        }
        JpaEventStoreProvider.setDetails(adminEventEntity::setDetailsJson, adminEvent.getDetails());
        return adminEventEntity;
    }

    static AdminEvent convertAdminEvent(AdminEventEntity adminEventEntity) {
        AdminEvent adminEvent = new AdminEvent();
        adminEvent.setId(adminEventEntity.getId() == null ? UUID.randomUUID().toString() : adminEventEntity.getId());
        adminEvent.setTime(adminEventEntity.getTime());
        adminEvent.setRealmId(adminEventEntity.getRealmId());
        JpaEventStoreProvider.setAuthDetails(adminEvent, adminEventEntity);
        adminEvent.setOperationType(OperationType.valueOf((String)adminEventEntity.getOperationType()));
        if (adminEventEntity.getResourceType() != null) {
            adminEvent.setResourceTypeAsString(adminEventEntity.getResourceType());
        }
        adminEvent.setResourcePath(adminEventEntity.getResourcePath());
        adminEvent.setError(adminEventEntity.getError());
        if (adminEventEntity.getRepresentation() != null) {
            adminEvent.setRepresentation(adminEventEntity.getRepresentation());
        }
        JpaEventStoreProvider.setDetails(arg_0 -> ((AdminEvent)adminEvent).setDetails(arg_0), adminEventEntity.getDetailsJson());
        return adminEvent;
    }

    private static void setAuthDetails(AdminEventEntity adminEventEntity, AuthDetails authDetails) {
        adminEventEntity.setAuthRealmId(authDetails.getRealmId());
        adminEventEntity.setAuthClientId(authDetails.getClientId());
        adminEventEntity.setAuthUserId(authDetails.getUserId());
        adminEventEntity.setAuthIpAddress(authDetails.getIpAddress());
    }

    private static void setAuthDetails(AdminEvent adminEvent, AdminEventEntity adminEventEntity) {
        AuthDetails authDetails = new AuthDetails();
        authDetails.setRealmId(adminEventEntity.getAuthRealmId());
        authDetails.setClientId(adminEventEntity.getAuthClientId());
        authDetails.setUserId(adminEventEntity.getAuthUserId());
        authDetails.setIpAddress(adminEventEntity.getAuthIpAddress());
        adminEvent.setAuthDetails(authDetails);
    }

    protected void clearExpiredAdminEvents() {
        TypedQuery query = this.em.createNamedQuery("selectRealmAttributesNotEmptyByName", RealmAttributeEntity.class).setParameter("name", (Object)"adminEventsExpiration");
        Map<Long, List<RealmAttributeEntity>> realms = query.getResultStream().filter(attribute -> {
            try {
                return Long.parseLong(attribute.getValue()) > 0L;
            }
            catch (NumberFormatException ex) {
                logger.warnf("Unable to parse value '%s' for attribute '%s' in realm '%s' (expecting it to be decimal numeric)", new Object[]{attribute.getValue(), "adminEventsExpiration", attribute.getRealm().getId(), ex});
                return false;
            }
        }).collect(Collectors.groupingBy(attribute -> Long.valueOf(attribute.getValue())));
        long current = Time.currentTimeMillis();
        realms.forEach((key, value) -> {
            List realmIds = value.stream().map(RealmAttributeEntity::getRealm).map(RealmEntity::getId).collect(Collectors.toList());
            int currentNumDeleted = this.em.createQuery("delete from AdminEventEntity where realmId in :realmIds and time < :eventTime").setParameter("realmIds", realmIds).setParameter("eventTime", (Object)(current - key * 1000L)).executeUpdate();
            logger.tracef("Deleted %d admin events for the expiration %d", currentNumDeleted, key);
        });
    }

    private static void setDetails(Consumer<String> setter, Map<String, String> details) {
        if (details != null) {
            try {
                setter.accept(mapper.writeValueAsString(details));
            }
            catch (IOException e) {
                logger.error((Object)"Failed to write event details", (Throwable)e);
            }
        }
    }

    private static void setDetails(Consumer<Map<String, String>> setter, String details) {
        if (details != null) {
            try {
                setter.accept((Map)mapper.readValue(details, mapType));
            }
            catch (IOException e) {
                logger.error((Object)"Failed to read event details", (Throwable)e);
            }
        }
    }
}

