/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.jpa;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.events.jpa.AdminEventEntity;
import org.keycloak.events.jpa.EventEntity;
import org.keycloak.events.jpa.JpaAdminEventQuery;
import org.keycloak.events.jpa.JpaEventQuery;

public class JpaEventStoreProvider
implements EventStoreProvider {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, String>> mapType = new TypeReference<Map<String, String>>(){};
    private static final Logger logger = Logger.getLogger(JpaEventStoreProvider.class);
    private EntityManager em;

    public JpaEventStoreProvider(EntityManager em) {
        this.em = em;
    }

    public EventQuery createQuery() {
        return new JpaEventQuery(this.em);
    }

    public void clear() {
        this.em.createQuery("delete from EventEntity").executeUpdate();
    }

    public void clear(String realmId) {
        this.em.createQuery("delete from EventEntity where realmId = :realmId").setParameter("realmId", (Object)realmId).executeUpdate();
    }

    public void clear(String realmId, long olderThan) {
        this.em.createQuery("delete from EventEntity where realmId = :realmId and time < :time").setParameter("realmId", (Object)realmId).setParameter("time", (Object)olderThan).executeUpdate();
    }

    public void onEvent(Event event) {
        this.em.persist((Object)JpaEventStoreProvider.convertEvent(event));
    }

    public AdminEventQuery createAdminQuery() {
        return new JpaAdminEventQuery(this.em);
    }

    public void clearAdmin() {
        this.em.createQuery("delete from AdminEventEntity").executeUpdate();
    }

    public void clearAdmin(String realmId) {
        this.em.createQuery("delete from AdminEventEntity where realmId = :realmId").setParameter("realmId", (Object)realmId).executeUpdate();
    }

    public void clearAdmin(String realmId, long olderThan) {
        this.em.createQuery("delete from AdminEventEntity where realmId = :realmId and time < :time").setParameter("realmId", (Object)realmId).setParameter("time", (Object)olderThan).executeUpdate();
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        this.em.persist((Object)JpaEventStoreProvider.convertAdminEvent(event, includeRepresentation));
    }

    public void close() {
    }

    static EventEntity convertEvent(Event event) {
        EventEntity eventEntity = new EventEntity();
        eventEntity.setId(UUID.randomUUID().toString());
        eventEntity.setTime(event.getTime());
        eventEntity.setType(event.getType().toString());
        eventEntity.setRealmId(event.getRealmId());
        eventEntity.setClientId(event.getClientId());
        eventEntity.setUserId(event.getUserId());
        eventEntity.setSessionId(event.getSessionId());
        eventEntity.setIpAddress(event.getIpAddress());
        eventEntity.setError(event.getError());
        try {
            eventEntity.setDetailsJson(mapper.writeValueAsString((Object)event.getDetails()));
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to write log details", (Throwable)ex);
        }
        return eventEntity;
    }

    static Event convertEvent(EventEntity eventEntity) {
        Event event = new Event();
        event.setTime(eventEntity.getTime());
        event.setType(EventType.valueOf((String)eventEntity.getType()));
        event.setRealmId(eventEntity.getRealmId());
        event.setClientId(eventEntity.getClientId());
        event.setUserId(eventEntity.getUserId());
        event.setSessionId(eventEntity.getSessionId());
        event.setIpAddress(eventEntity.getIpAddress());
        event.setError(eventEntity.getError());
        try {
            Map details = (Map)mapper.readValue(eventEntity.getDetailsJson(), mapType);
            event.setDetails(details);
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to read log details", (Throwable)ex);
        }
        return event;
    }

    static AdminEventEntity convertAdminEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        AdminEventEntity adminEventEntity = new AdminEventEntity();
        adminEventEntity.setId(UUID.randomUUID().toString());
        adminEventEntity.setTime(adminEvent.getTime());
        adminEventEntity.setRealmId(adminEvent.getRealmId());
        JpaEventStoreProvider.setAuthDetails(adminEventEntity, adminEvent.getAuthDetails());
        adminEventEntity.setOperationType(adminEvent.getOperationType().toString());
        if (adminEvent.getResourceType() != null) {
            adminEventEntity.setResourceType(adminEvent.getResourceType().toString());
        }
        adminEventEntity.setResourcePath(adminEvent.getResourcePath());
        adminEventEntity.setError(adminEvent.getError());
        if (includeRepresentation) {
            adminEventEntity.setRepresentation(adminEvent.getRepresentation());
        }
        return adminEventEntity;
    }

    static AdminEvent convertAdminEvent(AdminEventEntity adminEventEntity) {
        AdminEvent adminEvent = new AdminEvent();
        adminEvent.setTime(adminEventEntity.getTime());
        adminEvent.setRealmId(adminEventEntity.getRealmId());
        JpaEventStoreProvider.setAuthDetails(adminEvent, adminEventEntity);
        adminEvent.setOperationType(OperationType.valueOf((String)adminEventEntity.getOperationType()));
        if (adminEventEntity.getResourceType() != null) {
            adminEvent.setResourceType(ResourceType.valueOf((String)adminEventEntity.getResourceType()));
        }
        adminEvent.setResourcePath(adminEventEntity.getResourcePath());
        adminEvent.setError(adminEventEntity.getError());
        if (adminEventEntity.getRepresentation() != null) {
            adminEvent.setRepresentation(adminEventEntity.getRepresentation());
        }
        return adminEvent;
    }

    private static void setAuthDetails(AdminEventEntity adminEventEntity, AuthDetails authDetails) {
        adminEventEntity.setAuthRealmId(authDetails.getRealmId());
        adminEventEntity.setAuthClientId(authDetails.getClientId());
        adminEventEntity.setAuthUserId(authDetails.getUserId());
        adminEventEntity.setAuthIpAddress(authDetails.getIpAddress());
    }

    private static void setAuthDetails(AdminEvent adminEvent, AdminEventEntity adminEventEntity) {
        AuthDetails authDetails = new AuthDetails();
        authDetails.setRealmId(adminEventEntity.getAuthRealmId());
        authDetails.setClientId(adminEventEntity.getAuthClientId());
        authDetails.setUserId(adminEventEntity.getAuthUserId());
        authDetails.setIpAddress(adminEventEntity.getAuthIpAddress());
        adminEvent.setAuthDetails(authDetails);
    }
}

