/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.CredentialAttributeEntity;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JpaUserCredentialStore
implements UserCredentialStore {
    private final KeycloakSession session;
    protected final EntityManager em;

    public JpaUserCredentialStore(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)cred.getId());
        if (entity == null) {
            return;
        }
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        if (!entity.getCredentialAttributes().isEmpty() || cred.getConfig() != null && !cred.getConfig().isEmpty()) {
            MultivaluedHashMap attrs = cred.getConfig();
            MultivaluedHashMap config = cred.getConfig();
            if (config == null) {
                config = new MultivaluedHashMap();
            }
            Iterator<CredentialAttributeEntity> it = entity.getCredentialAttributes().iterator();
            while (it.hasNext()) {
                CredentialAttributeEntity attr = it.next();
                List values = config.getList((Object)attr.getName());
                if (values == null || !values.contains(attr.getValue())) {
                    this.em.remove((Object)attr);
                    it.remove();
                    continue;
                }
                attrs.add((Object)attr.getName(), (Object)attr.getValue());
            }
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                List attrValues = attrs.getList((Object)key);
                for (String val : values) {
                    if (attrValues != null && attrValues.contains(val)) continue;
                    CredentialAttributeEntity attr = new CredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = new CredentialEntity();
        String id = cred.getId() == null ? KeycloakModelUtils.generateId() : cred.getId();
        entity.setId(id);
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        UserEntity userRef = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userRef);
        this.em.persist((Object)entity);
        MultivaluedHashMap config = cred.getConfig();
        if (config != null && !config.isEmpty()) {
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                for (String val : values) {
                    CredentialAttributeEntity attr = new CredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)id);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = (CredentialEntity)this.em.find(CredentialEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        CredentialModel model = this.toModel(entity);
        return model;
    }

    protected CredentialModel toModel(CredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setValue(entity.getValue());
        model.setAlgorithm(entity.getAlgorithm());
        model.setSalt(entity.getSalt());
        model.setPeriod(entity.getPeriod());
        model.setCounter(entity.getCounter());
        model.setCreatedDate(entity.getCreatedDate());
        model.setDevice(entity.getDevice());
        model.setDigits(entity.getDigits());
        MultivaluedHashMap config = new MultivaluedHashMap();
        model.setConfig(config);
        for (CredentialAttributeEntity attr : entity.getCredentialAttributes()) {
            config.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return model;
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        TypedQuery query = this.em.createNamedQuery("credentialByUser", CredentialEntity.class).setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (CredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        TypedQuery query = this.em.createNamedQuery("credentialByUserAndType", CredentialEntity.class).setParameter("type", (Object)type).setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (CredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        TypedQuery query = this.em.createNamedQuery("credentialByNameAndType", CredentialEntity.class).setParameter("type", (Object)type).setParameter("device", (Object)name).setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return this.toModel((CredentialEntity)results.get(0));
    }

    public void close() {
    }
}

