/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import javax.persistence.EntityManager;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.store.ResourceAdapter;
import org.keycloak.authorization.model.AbstractAuthorizationModel;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;

public class ResourceServerAdapter
extends AbstractAuthorizationModel
implements ResourceServer,
JpaModel<ResourceServerEntity> {
    private ResourceServerEntity entity;
    private EntityManager em;
    private StoreFactory storeFactory;

    public ResourceServerAdapter(ResourceServerEntity entity, EntityManager em, StoreFactory storeFactory) {
        super(storeFactory);
        this.entity = entity;
        this.em = em;
        this.storeFactory = storeFactory;
    }

    @Override
    public ResourceServerEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public boolean isAllowRemoteResourceManagement() {
        return this.entity.isAllowRemoteResourceManagement();
    }

    public void setAllowRemoteResourceManagement(boolean allowRemoteResourceManagement) {
        this.throwExceptionIfReadonly();
        this.entity.setAllowRemoteResourceManagement(allowRemoteResourceManagement);
    }

    public PolicyEnforcementMode getPolicyEnforcementMode() {
        return this.entity.getPolicyEnforcementMode();
    }

    public void setPolicyEnforcementMode(PolicyEnforcementMode enforcementMode) {
        this.throwExceptionIfReadonly();
        this.entity.setPolicyEnforcementMode(enforcementMode);
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.entity.getDecisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.throwExceptionIfReadonly();
        this.entity.setDecisionStrategy(decisionStrategy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ResourceServer)) {
            return false;
        }
        ResourceServer that = (ResourceServer)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static ResourceServerEntity toEntity(EntityManager em, ResourceServer resource) {
        if (resource instanceof ResourceAdapter) {
            return ((ResourceServerAdapter)resource).getEntity();
        }
        return (ResourceServerEntity)em.getReference(ResourceServerEntity.class, (Object)resource.getId());
    }
}

