/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate4_0_0_DefaultClientScopes
extends CustomKeycloakTask {
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String clientTableName = this.database.correctObjectName("CLIENT", Table.class);
        String clientScopeClientTableName = this.database.correctObjectName("CLIENT_SCOPE_CLIENT", Table.class);
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("SELECT ID, CLIENT_TEMPLATE_ID FROM " + clientTableName);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                String clientId = rs.getString(1);
                String clientTemplateId = rs.getString(2);
                if (clientId == null || clientId.trim().isEmpty() || clientTemplateId == null || clientTemplateId.trim().isEmpty()) continue;
                this.statements.add(new InsertStatement(null, null, clientScopeClientTableName).addColumnValue("CLIENT_ID", (Object)clientId.trim()).addColumnValue("SCOPE_ID", (Object)clientTemplateId.trim()).addColumnValue("DEFAULT_SCOPE", (Object)Boolean.TRUE));
            }
            this.confirmationMessage.append("Updated " + this.statements.size() + " records in CLIENT_SCOPE_CLIENT table");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Update 4.0.0.Final (Default client scopes)";
    }
}

