/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authSession;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodAuthenticationSessionEntity;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodAuthenticationSessionEntityDelegate;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodRootAuthenticationSessionEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@ProtoDoc(value="@Indexed")
public class HotRodRootAuthenticationSessionEntity
extends AbstractHotRodEntity {
    @ProtoField(number=1, required=true)
    public int entityVersion = 1;
    @ProtoField(number=2, required=true)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoField(number=4)
    public Long timestamp;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=5)
    public Long expiration;
    @ProtoField(number=6)
    public Set<HotRodAuthenticationSessionEntity> authenticationSessions;

    public boolean equals(Object o) {
        return HotRodRootAuthenticationSessionEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodRootAuthenticationSessionEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodRootAuthenticationSessionEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodRootAuthenticationSessionEntity>
    implements MapRootAuthenticationSessionEntity {
        public String getId() {
            return ((HotRodRootAuthenticationSessionEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodRootAuthenticationSessionEntity entity = (HotRodRootAuthenticationSessionEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public Optional<MapAuthenticationSessionEntity> getAuthenticationSession(String tabId) {
            HotRodRootAuthenticationSessionEntity rootAuthSession = (HotRodRootAuthenticationSessionEntity)this.getHotRodEntity();
            if (rootAuthSession.authenticationSessions == null || rootAuthSession.authenticationSessions.isEmpty()) {
                return Optional.empty();
            }
            return rootAuthSession.authenticationSessions.stream().filter(as -> Objects.equals(as.tabId, tabId)).findFirst().map(HotRodAuthenticationSessionEntityDelegate::new);
        }

        public Boolean removeAuthenticationSession(String tabId) {
            HotRodRootAuthenticationSessionEntity rootAuthSession = (HotRodRootAuthenticationSessionEntity)this.getHotRodEntity();
            boolean removed = rootAuthSession.authenticationSessions != null && rootAuthSession.authenticationSessions.removeIf(c -> Objects.equals(c.tabId, tabId));
            rootAuthSession.updated |= removed;
            return removed;
        }

        @Override
        public boolean isUpdated() {
            HotRodRootAuthenticationSessionEntity rootAuthSession = (HotRodRootAuthenticationSessionEntity)this.getHotRodEntity();
            return rootAuthSession.updated || Optional.ofNullable(this.getAuthenticationSessions()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            HotRodRootAuthenticationSessionEntity rootAuthSession = (HotRodRootAuthenticationSessionEntity)this.getHotRodEntity();
            rootAuthSession.updated = false;
            Optional.ofNullable(this.getAuthenticationSessions()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }
    }
}

