/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.user;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.jboss.logging.Logger;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserConsentEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserConsentEntityDelegate;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserCredentialEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserCredentialEntityDelegate;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserEntityDelegate;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserFederatedIdentityEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserFederatedIdentityEntityDelegate;
import org.keycloak.models.map.user.MapUserConsentEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@ProtoDoc(value="@Indexed")
public class HotRodUserEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    private static final Logger LOG = Logger.getLogger(HotRodUserEntity.class);
    @ProtoField(number=1, required=true)
    public int entityVersion = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=2, required=true)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoField(number=4)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String username;
    @ProtoField(number=22)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String usernameLowercase;
    @ProtoField(number=5)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"filename\"))")
    public String firstName;
    @ProtoField(number=6)
    public Long createdTimestamp;
    @ProtoField(number=7)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"filename\"))")
    public String lastName;
    @ProtoField(number=8)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"filename\"))")
    public String email;
    @ProtoField(number=9)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Boolean enabled;
    @ProtoField(number=10)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Boolean emailVerified;
    @ProtoField(number=11)
    public String emailConstraint;
    @ProtoField(number=12)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<HotRodAttributeEntity> attributes;
    @ProtoField(number=13)
    public Set<String> requiredActions;
    @ProtoField(number=14)
    public List<HotRodUserCredentialEntity> credentials;
    @ProtoField(number=15)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<HotRodUserFederatedIdentityEntity> federatedIdentities;
    @ProtoField(number=16)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<HotRodUserConsentEntity> userConsents;
    @ProtoField(number=17)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<String> groupsMembership = new HashSet<String>();
    @ProtoField(number=18)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<String> rolesMembership = new HashSet<String>();
    @ProtoField(number=19)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String federationLink;
    @ProtoField(number=20)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String serviceAccountClientLink;
    @ProtoField(number=21)
    public Long notBefore;

    public boolean equals(Object o) {
        return HotRodUserEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodUserEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodUserEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodUserEntity>
    implements MapUserEntity {
        public String getId() {
            return ((HotRodUserEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodUserEntity entity = (HotRodUserEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setEmail(String email, boolean duplicateEmailsAllowed) {
            this.setEmail(email);
            this.setEmailConstraint(email == null || duplicateEmailsAllowed ? KeycloakModelUtils.generateId() : email);
        }

        public void setUsername(String username) {
            HotRodUserEntity entity = (HotRodUserEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.username, username);
            entity.username = username;
            entity.usernameLowercase = username == null ? null : username.toLowerCase();
        }

        @Override
        public boolean isUpdated() {
            return ((HotRodUserEntity)this.getHotRodEntity()).updated || Optional.ofNullable(this.getUserConsents()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getCredentials()).orElseGet(Collections::emptyList).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getFederatedIdentities()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            ((HotRodUserEntity)this.getHotRodEntity()).updated = false;
            Optional.ofNullable(this.getUserConsents()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getCredentials()).orElseGet(Collections::emptyList).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getFederatedIdentities()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }

        public Optional<MapUserConsentEntity> getUserConsent(String clientId) {
            Set<HotRodUserConsentEntity> ucs = ((HotRodUserEntity)this.getHotRodEntity()).userConsents;
            if (ucs == null || ucs.isEmpty()) {
                return Optional.empty();
            }
            return ucs.stream().filter(uc -> Objects.equals(uc.clientId, clientId)).findFirst().map(HotRodUserConsentEntityDelegate::new);
        }

        public Boolean removeUserConsent(String clientId) {
            Set<HotRodUserConsentEntity> consents = ((HotRodUserEntity)this.getHotRodEntity()).userConsents;
            boolean removed = consents != null && consents.removeIf(uc -> Objects.equals(uc.clientId, clientId));
            ((HotRodUserEntity)this.getHotRodEntity()).updated |= removed;
            return removed;
        }

        public Optional<MapUserCredentialEntity> getCredential(String id) {
            List<HotRodUserCredentialEntity> uce = ((HotRodUserEntity)this.getHotRodEntity()).credentials;
            if (uce == null || uce.isEmpty()) {
                return Optional.empty();
            }
            return uce.stream().filter(uc -> Objects.equals(uc.id, id)).findFirst().map(HotRodUserCredentialEntityDelegate::new);
        }

        public Boolean removeCredential(String id) {
            List<HotRodUserCredentialEntity> credentials = ((HotRodUserEntity)this.getHotRodEntity()).credentials;
            boolean removed = credentials != null && credentials.removeIf(c -> Objects.equals(c.id, id));
            ((HotRodUserEntity)this.getHotRodEntity()).updated |= removed;
            return removed;
        }

        public Boolean moveCredential(String credentialId, String newPreviousCredentialId) {
            int toMoveIndex;
            List<HotRodUserCredentialEntity> credentialsList = ((HotRodUserEntity)this.getHotRodEntity()).credentials;
            int ourCredentialIndex = -1;
            int newPreviousCredentialIndex = -1;
            HotRodUserCredentialEntity ourCredential = null;
            int i = 0;
            for (HotRodUserCredentialEntity credential : credentialsList) {
                if (credentialId.equals(credential.id)) {
                    ourCredentialIndex = i;
                    ourCredential = credential;
                } else if (newPreviousCredentialId != null && newPreviousCredentialId.equals(credential.id)) {
                    newPreviousCredentialIndex = i;
                }
                ++i;
            }
            if (ourCredentialIndex == -1) {
                LOG.warnf("Not found credential with id [%s] of user [%s]", (Object)credentialId, (Object)this.getUsername());
                return false;
            }
            if (newPreviousCredentialId != null && newPreviousCredentialIndex == -1) {
                LOG.warnf("Can't move up credential with id [%s] of user [%s]", (Object)credentialId, (Object)this.getUsername());
                return false;
            }
            int n = toMoveIndex = newPreviousCredentialId == null ? 0 : newPreviousCredentialIndex + 1;
            if (toMoveIndex == ourCredentialIndex) {
                return true;
            }
            credentialsList.add(toMoveIndex, ourCredential);
            int indexToRemove = toMoveIndex < ourCredentialIndex ? ourCredentialIndex + 1 : ourCredentialIndex;
            credentialsList.remove(indexToRemove);
            ((HotRodUserEntity)this.getHotRodEntity()).updated = true;
            return true;
        }

        public Optional<MapUserFederatedIdentityEntity> getFederatedIdentity(String identityProviderId) {
            Set<HotRodUserFederatedIdentityEntity> fes = ((HotRodUserEntity)this.getHotRodEntity()).federatedIdentities;
            if (fes == null || fes.isEmpty()) {
                return Optional.empty();
            }
            return fes.stream().filter(fi -> Objects.equals(fi.identityProvider, identityProviderId)).findFirst().map(HotRodUserFederatedIdentityEntityDelegate::new);
        }

        public Boolean removeFederatedIdentity(String identityProviderId) {
            Set<HotRodUserFederatedIdentityEntity> federatedIdentities = ((HotRodUserEntity)this.getHotRodEntity()).federatedIdentities;
            boolean removed = federatedIdentities != null && federatedIdentities.removeIf(fi -> Objects.equals(fi.identityProvider, identityProviderId));
            ((HotRodUserEntity)this.getHotRodEntity()).updated |= removed;
            return removed;
        }
    }
}

