/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.common;

import java.util.function.Function;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;

public class HotRodEntityDescriptor<E, D extends HotRodEntityDelegate<E>> {
    private final Class<?> modelTypeClass;
    private final Class<E> entityTypeClass;
    private final Function<E, D> hotRodDelegateProvider;

    public HotRodEntityDescriptor(Class<?> modelTypeClass, Class<E> entityTypeClass, Function<E, D> hotRodDelegateProvider) {
        this.modelTypeClass = modelTypeClass;
        this.entityTypeClass = entityTypeClass;
        this.hotRodDelegateProvider = hotRodDelegateProvider;
    }

    public Class<?> getModelTypeClass() {
        return this.modelTypeClass;
    }

    public Class<E> getEntityTypeClass() {
        return this.entityTypeClass;
    }

    public String getCacheName() {
        return ModelEntityUtil.getModelName(this.modelTypeClass);
    }

    public Function<E, D> getHotRodDelegateProvider() {
        return this.hotRodDelegateProvider;
    }
}

