/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authorization;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoDocs;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodPolicyEntityDelegate;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodPolicyEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodStringPair;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@ProtoDocs(value={@ProtoDoc(value="@Indexed"), @ProtoDoc(value="schema-version: 1")})
public class HotRodPolicyEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=2)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoField(number=4)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String name;
    @ProtoField(number=5)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String nameLowercase;
    @ProtoField(number=6)
    public String description;
    @ProtoField(number=7)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"filename\"))")
    public String type;
    @ProtoField(number=8)
    public Integer decisionStrategy;
    @ProtoField(number=9)
    public Integer logic;
    @ProtoField(number=10)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<HotRodStringPair> configs;
    @ProtoField(number=11)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String resourceServerId;
    @ProtoField(number=12)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<String> associatedPolicyIds;
    @ProtoField(number=13)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<String> resourceIds;
    @ProtoField(number=14)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<String> scopeIds;
    @ProtoField(number=15)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String owner;

    public boolean equals(Object o) {
        return HotRodPolicyEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodPolicyEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodPolicyEntity
    extends UpdatableHotRodEntityDelegateImpl<HotRodPolicyEntity>
    implements MapPolicyEntity {
        public String getId() {
            return ((HotRodPolicyEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodPolicyEntity entity = (HotRodPolicyEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setName(String name) {
            HotRodPolicyEntity entity = (HotRodPolicyEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.name, name);
            entity.name = name;
            entity.nameLowercase = name == null ? null : name.toLowerCase();
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodPolicyEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodPolicyEntitySchema
    extends GeneratedSchema {
        public static final HotRodPolicyEntitySchema INSTANCE = new HotRodPolicyEntitySchemaImpl();
    }
}

