/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mem;

import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.mem.MemUserSessionProvider;
import org.keycloak.models.sessions.mem.UserSessionAdapter;
import org.keycloak.models.sessions.mem.entities.ClientSessionEntity;
import org.keycloak.models.sessions.mem.entities.UserSessionEntity;

public class ClientSessionAdapter
implements ClientSessionModel {
    private KeycloakSession session;
    private MemUserSessionProvider provider;
    private RealmModel realm;
    private ClientSessionEntity entity;

    public ClientSessionAdapter(KeycloakSession session, MemUserSessionProvider provider, RealmModel realm, ClientSessionEntity entity) {
        this.session = session;
        this.provider = provider;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.session.realms().getRealm(this.entity.getRealmId());
    }

    public ClientModel getClient() {
        return this.realm.getClientById(this.entity.getClientId());
    }

    public UserSessionModel getUserSession() {
        if (this.entity.getSession() == null) {
            return null;
        }
        return new UserSessionAdapter(this.session, this.provider, this.realm, this.entity.getSession());
    }

    public void setUserSession(UserSessionModel userSession) {
        if (userSession == null) {
            if (this.entity.getSession() != null) {
                this.entity.getSession().getClientSessions().remove(this.entity);
            }
            this.entity.setSession(null);
        } else {
            UserSessionAdapter adapter = (UserSessionAdapter)userSession;
            UserSessionEntity userSessionEntity = adapter.getEntity();
            this.entity.setSession(userSessionEntity);
            userSessionEntity.getClientSessions().add(this.entity);
        }
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
    }

    public void setRoles(Set<String> roles) {
        this.entity.setRoles(roles);
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
    }

    public ClientSessionModel.Action getAction() {
        return this.entity.getAction();
    }

    public void setAction(ClientSessionModel.Action action) {
        this.entity.setAction(action);
    }

    public Set<String> getRoles() {
        return this.entity.getRoles();
    }

    public Set<String> getProtocolMappers() {
        return this.entity.getProtocolMappers();
    }

    public void setProtocolMappers(Set<String> protocolMappers) {
        this.entity.setProtocolMappers(protocolMappers);
    }

    public String getNote(String name) {
        return this.entity.getNotes().get(name);
    }

    public void setNote(String name, String value) {
        this.entity.getNotes().put(name, value);
    }

    public void removeNote(String name) {
        this.entity.getNotes().remove(name);
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public void setAuthMethod(String method) {
        this.entity.setAuthMethod(method);
    }

    public Map<String, UserSessionModel.AuthenticatorStatus> getAuthenticators() {
        return this.entity.getAuthenticatorStatus();
    }

    public void setAuthenticatorStatus(String authenticator, UserSessionModel.AuthenticatorStatus status) {
        this.entity.getAuthenticatorStatus().put(authenticator, status);
    }

    public void setAuthenticatorStatus(Map<String, UserSessionModel.AuthenticatorStatus> status) {
        this.entity.setAuthenticatorStatus(status);
    }

    public UserModel getAuthenticatedUser() {
        return this.session.users().getUserById(this.entity.getAuthUserId(), this.realm);
    }

    public void setAuthenticatedUser(UserModel user) {
        this.entity.setAuthUserId(user.getId());
    }
}

