/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.datastore;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.migration.MigrationModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.MigrateTo12_0_0;
import org.keycloak.migration.migrators.MigrateTo14_0_0;
import org.keycloak.migration.migrators.MigrateTo18_0_0;
import org.keycloak.migration.migrators.MigrateTo1_2_0;
import org.keycloak.migration.migrators.MigrateTo1_3_0;
import org.keycloak.migration.migrators.MigrateTo1_4_0;
import org.keycloak.migration.migrators.MigrateTo1_5_0;
import org.keycloak.migration.migrators.MigrateTo1_6_0;
import org.keycloak.migration.migrators.MigrateTo1_7_0;
import org.keycloak.migration.migrators.MigrateTo1_8_0;
import org.keycloak.migration.migrators.MigrateTo1_9_0;
import org.keycloak.migration.migrators.MigrateTo1_9_2;
import org.keycloak.migration.migrators.MigrateTo20_0_0;
import org.keycloak.migration.migrators.MigrateTo21_0_0;
import org.keycloak.migration.migrators.MigrateTo22_0_0;
import org.keycloak.migration.migrators.MigrateTo23_0_0;
import org.keycloak.migration.migrators.MigrateTo24_0_0;
import org.keycloak.migration.migrators.MigrateTo2_0_0;
import org.keycloak.migration.migrators.MigrateTo2_1_0;
import org.keycloak.migration.migrators.MigrateTo2_2_0;
import org.keycloak.migration.migrators.MigrateTo2_3_0;
import org.keycloak.migration.migrators.MigrateTo2_5_0;
import org.keycloak.migration.migrators.MigrateTo3_0_0;
import org.keycloak.migration.migrators.MigrateTo3_1_0;
import org.keycloak.migration.migrators.MigrateTo3_2_0;
import org.keycloak.migration.migrators.MigrateTo3_4_0;
import org.keycloak.migration.migrators.MigrateTo3_4_1;
import org.keycloak.migration.migrators.MigrateTo3_4_2;
import org.keycloak.migration.migrators.MigrateTo4_0_0;
import org.keycloak.migration.migrators.MigrateTo4_2_0;
import org.keycloak.migration.migrators.MigrateTo4_6_0;
import org.keycloak.migration.migrators.MigrateTo6_0_0;
import org.keycloak.migration.migrators.MigrateTo8_0_0;
import org.keycloak.migration.migrators.MigrateTo8_0_2;
import org.keycloak.migration.migrators.MigrateTo9_0_0;
import org.keycloak.migration.migrators.MigrateTo9_0_4;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.DeploymentStateProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.MigrationManager;

public class DefaultMigrationManager
implements MigrationManager {
    private static final Logger logger = Logger.getLogger(DefaultMigrationManager.class);
    private static final Migration[] migrations = new Migration[]{new MigrateTo1_2_0(), new MigrateTo1_3_0(), new MigrateTo1_4_0(), new MigrateTo1_5_0(), new MigrateTo1_6_0(), new MigrateTo1_7_0(), new MigrateTo1_8_0(), new MigrateTo1_9_0(), new MigrateTo1_9_2(), new MigrateTo2_0_0(), new MigrateTo2_1_0(), new MigrateTo2_2_0(), new MigrateTo2_3_0(), new MigrateTo2_5_0(), new MigrateTo3_0_0(), new MigrateTo3_1_0(), new MigrateTo3_2_0(), new MigrateTo3_4_0(), new MigrateTo3_4_1(), new MigrateTo3_4_2(), new MigrateTo4_0_0(), new MigrateTo4_2_0(), new MigrateTo4_6_0(), new MigrateTo6_0_0(), new MigrateTo8_0_0(), new MigrateTo8_0_2(), new MigrateTo9_0_0(), new MigrateTo9_0_4(), new MigrateTo12_0_0(), new MigrateTo14_0_0(), new MigrateTo18_0_0(), new MigrateTo20_0_0(), new MigrateTo21_0_0(), new MigrateTo22_0_0(), new MigrateTo23_0_0(), new MigrateTo24_0_0()};
    private final KeycloakSession session;
    public static final ModelVersion RHSSO_VERSION_7_0_KEYCLOAK_VERSION = new ModelVersion("1.9.8");
    public static final ModelVersion RHSSO_VERSION_7_1_KEYCLOAK_VERSION = new ModelVersion("2.5.5");
    public static final ModelVersion RHSSO_VERSION_7_2_KEYCLOAK_VERSION = new ModelVersion("3.4.3");
    public static final ModelVersion RHSSO_VERSION_7_3_KEYCLOAK_VERSION = new ModelVersion("4.8.3");
    public static final ModelVersion RHSSO_VERSION_7_4_KEYCLOAK_VERSION = new ModelVersion("9.0.3");
    private static final Map<Pattern, ModelVersion> PATTERN_MATCHER = new LinkedHashMap<Pattern, ModelVersion>();

    public DefaultMigrationManager(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public void migrate() {
        ModelVersion databaseVersion;
        this.session.setAttribute("org.keycloak.storage.batch_enabled", (Object)Boolean.getBoolean("keycloak.migration.batch-enabled"));
        this.session.setAttribute("org.keycloak.storage.batch_size", (Object)Integer.getInteger("keycloak.migration.batch-size"));
        MigrationModel model = ((DeploymentStateProvider)this.session.getProvider(DeploymentStateProvider.class)).getMigrationModel();
        ModelVersion currentVersion = new ModelVersion(Version.VERSION);
        ModelVersion latestUpdate = migrations[migrations.length - 1].getVersion();
        ModelVersion modelVersion = databaseVersion = model.getStoredVersion() != null ? new ModelVersion(model.getStoredVersion()) : null;
        if (databaseVersion == null || databaseVersion.lessThan(latestUpdate)) {
            for (Migration m : migrations) {
                if (databaseVersion != null && !databaseVersion.lessThan(m.getVersion())) continue;
                if (databaseVersion != null) {
                    logger.debugf("Migrating older model to %s", (Object)m.getVersion());
                }
                m.migrate(this.session);
            }
        }
        if (databaseVersion == null || databaseVersion.lessThan(currentVersion)) {
            model.setStoredVersion(currentVersion.toString());
        }
        Version.RESOURCES_VERSION = model.getResourcesTag();
    }

    @Override
    public void migrate(RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        ModelVersion stored = null;
        if (rep.getKeycloakVersion() != null && (stored = DefaultMigrationManager.convertRHSSOVersionToKeycloakVersion(rep.getKeycloakVersion())) == null) {
            stored = new ModelVersion(rep.getKeycloakVersion());
        }
        if (stored == null) {
            stored = migrations[0].getVersion();
        }
        for (Migration m : migrations) {
            if (stored != null && !stored.lessThan(m.getVersion())) continue;
            if (stored != null) {
                logger.debugf("Migrating older json representation to %s", (Object)m.getVersion());
            }
            try {
                m.migrateImport(this.session, realm, rep, skipUserDependent);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to migrate json representation for version: " + m.getVersion()), (Throwable)e);
            }
        }
    }

    public static ModelVersion convertRHSSOVersionToKeycloakVersion(String version) {
        for (Pattern pattern : PATTERN_MATCHER.keySet()) {
            if (!pattern.matcher(version).find()) continue;
            return PATTERN_MATCHER.get(pattern);
        }
        if (Pattern.compile("^[0-9]*$").matcher(version).find()) {
            return new ModelVersion(Integer.parseInt(version), 0, 0);
        }
        return null;
    }

    static {
        PATTERN_MATCHER.put(Pattern.compile("^7\\.0\\.\\d+\\.GA$"), RHSSO_VERSION_7_0_KEYCLOAK_VERSION);
        PATTERN_MATCHER.put(Pattern.compile("^7\\.1\\.\\d+\\.GA$"), RHSSO_VERSION_7_1_KEYCLOAK_VERSION);
        PATTERN_MATCHER.put(Pattern.compile("^7\\.2\\.\\d+\\.GA$"), RHSSO_VERSION_7_2_KEYCLOAK_VERSION);
        PATTERN_MATCHER.put(Pattern.compile("^7\\.3\\.\\d+\\.GA$"), RHSSO_VERSION_7_3_KEYCLOAK_VERSION);
        PATTERN_MATCHER.put(Pattern.compile("^7\\.4\\.\\d+\\.GA$"), RHSSO_VERSION_7_4_KEYCLOAK_VERSION);
    }
}

