/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.lang.invoke.MethodHandles;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo26_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("26.0.0");
    private static final Logger LOG = Logger.getLogger(MethodHandles.lookup().lookupClass());

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        UserSessionProvider userSessions = session.sessions();
        if (userSessions != null) {
            userSessions.migrate(VERSION.toString());
        }
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    private void migrateRealm(KeycloakSession session, RealmModel realm) {
        ClientModel adminConsoleClient = realm.getClientByClientId("security-admin-console");
        adminConsoleClient.setFullScopeAllowed(true);
        adminConsoleClient.setAttribute("client.use.lightweight.access.token.enabled", String.valueOf(true));
        ClientModel adminCliClient = realm.getClientByClientId("admin-cli");
        adminCliClient.setFullScopeAllowed(true);
        adminCliClient.setAttribute("client.use.lightweight.access.token.enabled", String.valueOf(true));
    }
}

