/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo20_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("20.0.0");

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::addViewGroupsRole);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.addViewGroupsRole(realm);
    }

    private void addViewGroupsRole(RealmModel realm) {
        ClientModel accountClient = realm.getClientByClientId("account");
        if (accountClient != null && accountClient.getRole("view-groups") == null) {
            RoleModel viewGroupsRole = accountClient.addRole("view-groups");
            viewGroupsRole.setDescription("${role_view-groups}");
            ClientModel accountConsoleClient = realm.getClientByClientId("account-console");
            accountConsoleClient.addScopeMapping(viewGroupsRole);
        }
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

